/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;

public class ParameterWarningSuppressor
extends ClassWarningSuppressor {
    final MethodAnnotation method;
    final int register;

    public ParameterWarningSuppressor(String bugPattern, ClassAnnotation clazz, MethodAnnotation method, int register) {
        super(bugPattern, clazz);
        this.method = method;
        this.register = register;
    }

    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        MethodAnnotation bugMethod = bugInstance.getPrimaryMethod();
        LocalVariableAnnotation localVariable = bugInstance.getPrimaryLocalVariableAnnotation();
        if (bugMethod == null || !this.method.equals(bugMethod)) {
            return false;
        }
        if (localVariable == null || localVariable.getRegister() != this.register) {
            return false;
        }
        if (DEBUG) {
            System.out.println("Suppressing " + bugInstance);
        }
        return true;
    }
}

