/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractBlockOrder;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import java.util.Comparator;

public class ReverseDFSOrder
extends AbstractBlockOrder {
    public final ReverseDepthFirstSearch rdfs;
    public final DepthFirstSearch dfs;

    public ReverseDFSOrder(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        super(cfg, new ReverseDFSComparator(rdfs, dfs));
        this.rdfs = rdfs;
        this.dfs = dfs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseDFSComparator
    implements Comparator<BasicBlock> {
        private final DepthFirstSearch dfs;

        public ReverseDFSComparator(ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
            if (dfs == null) {
                throw new IllegalArgumentException();
            }
            this.dfs = dfs;
        }

        @Override
        public int compare(BasicBlock a, BasicBlock b) {
            return this.dfs.getFinishTime(a) - this.dfs.getFinishTime(b);
        }
    }
}

