//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.htmlmonitor;

/**
 * <p>
 * represents a web server including a port.
 * </p>
 * 
 * @author Patrick Harms
 */
class HtmlServer extends HtmlGUIElement {

    /**
     * the name of the represented server
     */
    private String name;
    
    /**
     * the port of the server (default is 80)
     */
    private int port = 80;
    
    /**
     * <p>
     * instantiates a new server element
     * </p>
     *
     * @param id   the id of the server
     * @param name the name of the server
     * @param port the port on the server
     *             (must be between 0 and 65536, otherwise default 80 is used)
     */
    HtmlServer(String id, String name, int port) {
        super(id, null);
        
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }

        this.name = name;
        
        if ((0 < port) && (port < 65536)) {
            this.port = port;
        }

    }

    /**
     * <p>
     * returns the name of the server
     * </p>
     * 
     * @return the name
     */
    String getName() {
        return name;
    }

    /**
     * <p>
     * returns the port on the server
     * </p>
     * 
     * @return the port
     */
    int getPort() {
        return port;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        else if (obj instanceof HtmlServer) {
            return equals((HtmlServer) obj);
        }
        else {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.htmlmonitor.HtmlGUIElement#equals(de.ugoe.cs.autoquest.htmlmonitor.HtmlGUIElement)
     */
    public boolean equals(HtmlServer other) {
        if (this == other) {
            return true;
        }

        return (name.equals(other.name) && (port == other.port));
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return name.hashCode() + port;
    }

}