//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.sandboxapp;

import static de.ugoe.cs.autoquest.usability.tasktree.filter.EventTypeFilter.MOUSE_BUTTON_INTERACTION;

import java.io.File;
import java.io.IOException;

import org.tc33.jheatchart.HeatChart;

import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.usability.tasktree.filter.FilterStatistic;
import de.ugoe.cs.autoquest.usability.tasktree.filter.IterativeDFSFilterStrategy;
import de.ugoe.cs.autoquest.usability.tasktree.filter.TaskTreeFilter;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskTreeUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class CreateHeatmapImageFromTaskTreeDemoApp {

    private static final String fileToParse = "javatrace.xml";

    private static final String heatmapFilename = "click-heatmap.png";

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromFile(fileToParse);
        FilterStatistic mouseInteractions = filterMouseInteractions(taskTree);
        double[][] data = fillHeatmapDataMatrix(mouseInteractions);
        createAndSaveHeatmapImage(mouseInteractions, data);
    }

    private static FilterStatistic filterMouseInteractions(ITaskTree taskTree) {
        return new TaskTreeFilter(new IterativeDFSFilterStrategy())
            .filterByEventType(MOUSE_BUTTON_INTERACTION).from(taskTree);
    }

    private static double[][] fillHeatmapDataMatrix(FilterStatistic mouseInteractions) {
        double data[][] = new double[1024][768];
        for (ITaskTreeNode node : mouseInteractions.nodesMatchedFilter()) {
            MouseButtonInteraction interaction =
                (MouseButtonInteraction) ((IEventTask) node).getEventType();
            int x = interaction.getX();
            int y = interaction.getY();
            data[x][y]++;
            boolean x_has_left = x - 1 >= 0;
            boolean x_has_right = x + 1 <= 800;
            boolean y_has_top = y - 1 >= 0;
            boolean y_has_bottem = y + 1 <= 800;
            if (x_has_left) {
                data[x - 1][y]++; // left
                if (y_has_top)
                    data[x - 1][y + 1]++; // topleft
                if (y_has_bottem)
                    data[x - 1][y - 1]++; // bottomleft
            }
            if (x_has_right) {
                data[x + 1][y]++; // right
                if (y_has_top)
                    data[x + 1][y + 1]++; // topright
                if (y_has_bottem)
                    data[x + 1][y - 1]++; // bottomright
            }
            if (y_has_top) {
                data[x][y + 1]++; // top
            }
            if (y_has_bottem) {
                data[x][y - 1]++; // bottom
            }
        }
        return data;
    }

    private static void createAndSaveHeatmapImage(FilterStatistic mouseInteractions, double[][] data)
        throws IOException
    {
        HeatChart hc = new HeatChart(data);
        hc.setTitle(mouseInteractions.nodesMatchedFilter().size() + "Mouse interactions");
        // Cautious, took some time!
        // Also you have to run the JVM with extended heapspace, like -Xms512m -Xmx4096m
        hc.saveToFile(new File(heatmapFilename));
    }

}
