package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDgenerateRandomSequences implements Command {

	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;
		int numSessions;
		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			numSessions = Integer.parseInt((String) parameters.get(2));
		}
		catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		IStochasticProcess model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + " not found in storage.");
		}
		else if( !(dataObject instanceof IStochasticProcess) ) {
			Console.println("Object " + modelname + " not of type MarkovModel!");
		} else {
			model = (IStochasticProcess) dataObject;
			List<List<? extends Event<?>>> sequences = new LinkedList<List<? extends Event<?>>>();
			for( int i=0 ; i<numSessions ; i++ ) {
				sequences.add(model.randomSequence());
			}
			if( GlobalDataContainer.getInstance().addData(sequencesName, sequences) ) {
				Console.traceln("Old data \"" + sequencesName + "\" overwritten");
			}
		}
	}

	@Override
	public void help() {
		Console.println("Usage: generateRandomSequenecs <modelName> <sequencesName> <numSessions>");
	}

}
