//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: InteractionEventListTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 04.12.2011 11:25:24 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.eventcore.userinteraction;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.userinteraction.InteractionEvent;
import de.ugoe.cs.quest.eventcore.userinteraction.InteractionEventList;
import de.ugoe.cs.quest.eventcore.userinteraction.KeyPressed;
import de.ugoe.cs.quest.eventcore.userinteraction.KeyReleased;
import de.ugoe.cs.tasktree.keyboardmaps.VirtualKey;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------

public class InteractionEventListTest
{

  //-----------------------------------------------------------------------------------------------
  /**
   * 
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testDifferentCombinationKeyCombinations()
  {
    List<InteractionEvent> checkList = new ArrayList<InteractionEvent>();
    InteractionEventList eventList = new InteractionEventList();
    
    GUIElement guiElement = new AbstractDefaultGUIElement()
    {
      @Override
      public boolean equals(GUIElement other)
      {
        return this == other;
      }
    };
    
    // check first of all a normal pressing and releasing of A and B
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_B)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_B)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_B)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_B)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // check what happens if A is pressed and not released before B is pressed
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_C)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_D)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_C)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_D)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_C)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_C)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_D)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_D)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // now SHIFT is pressed and released after all keys are pressed
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_E)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_E)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_F)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_F)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_E)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_E)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_F)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_F)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // now SHIFT is released before the last key is released
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_G)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_G)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_H)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_H)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_G)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_G)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_H)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_H)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // now SHIFT is released before all other keys are released
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_I)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_J)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_K)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_J)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_K)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_I)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_I)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_I)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_J)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_J)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_K)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_K)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // now SHIFT, CTRL and ALT are pressed and released after all keys are pressed
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_L)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_L)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_M)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_M)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_L)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_L)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_M)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_M)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
    
    // now SHIFT, CTRL and ALT are released before the last key is released
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_N)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_N)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_O)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_O)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_N)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_N)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_O)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_O)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }

    // now SHIFT, CTRL and ALT are released in another order and before some other keys are released
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_P)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_Q)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_R)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_Q)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_R)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_P)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_P)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_P)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_Q)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_Q)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_R)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_R)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.ALT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.CONTROL)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * 
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testSeveralSubsequentKeyPressedEvents()
  {
    List<InteractionEvent> checkList = new ArrayList<InteractionEvent>();
    InteractionEventList eventList = new InteractionEventList();
    
    GUIElement guiElement = new AbstractDefaultGUIElement()
    {
      @Override
      public boolean equals(GUIElement other)
      {
        return this == other;
      }
    };
    
    // check first of all a normal pressing and releasing of A and B
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }

    // check first of all a normal pressing and releasing of A and B
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    eventList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    eventList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.SHIFT)));
    checkList.add(new InteractionEvent(guiElement, new KeyPressed(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.LETTER_A)));
    checkList.add(new InteractionEvent(guiElement, new KeyReleased(VirtualKey.SHIFT)));
    
    assertEquals(checkList.size(), eventList.size());
    
    for (int i = 0; i < checkList.size(); i++)
    {
      assertEquals(checkList.get(i).getInteraction(), eventList.get(i).getInteraction());
    }
  }
    
}
