//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.emptyUsabilityRuleset;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.UsabilityEvaluationFacade.ExecuteUsabilityEvaluationStep;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityRuleset;
import de.ugoe.cs.autoquest.usability.testutil.TaskTreeBuilder;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityEvaluationFacadeTest {

    @Test(expected = NullPointerException.class)
    public void apply_null_for_ruleset_should_throw_exception() {
        UsabilityEvaluationFacade.applyUsabilityRuleset(null);
    }

    @Test
    public void apply_empty_ruleset_should_return_execute_usability_evaluation_step() {
        ExecuteUsabilityEvaluationStep executeUsabilityEvaluationStep =
            UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset());
        assertThat(executeUsabilityEvaluationStep)
            .isInstanceOf(ExecuteUsabilityEvaluationStep.class);
    }

    @Test(expected = NullPointerException.class)
    public void evaluate_usability_of_null_should_throw_exception() {
        UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset())
            .evaluateUsabilityOf(null);
    }

    @Test
    public void evaluate_usability_of_task_tree_against_empty_ruleset_should_return_empty_evaluation_report()
    {
        ITaskTree taskTree = TaskTreeBuilder.builder().root("Ich bin eine Wurzel").creatTaskTree();
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset())
                .evaluateUsabilityOf(taskTree);
        assertThat(evaluationReport).isNotNull();
    }

    @Test
    public void evaluate_usability_of_task_tree_against_dummy_ruleset_should_return_non_empty_evaluation_report()
    {
        ITaskTree taskTree = TaskTreeBuilder.builder().root("Ich bin eine Wurzel").creatTaskTree();
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationFacade.applyUsabilityRuleset(new DummyUsabilityRuleset())
                .evaluateUsabilityOf(taskTree);
        assertThat(evaluationReport).isNotNull();
    }

}
