//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.noUsabilityGuidlineRecommendations;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.usabilityGuidlineRecommendations;
import static org.fest.assertions.api.Assertions.assertThat;

import java.util.Collections;
import java.util.List;

import org.fest.util.Lists;
import org.junit.Test;

import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectSeverityLevel;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectFactory;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityGuidlineDescriptionResolver;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityRuleset;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityEvaluationReportTest {

    @Test(expected = NullPointerException.class)
    public void usability_report_from_null_should_throw_exception() {
        UsabilityEvaluationReport.from(null);
    }

    @Test
    public void usability_report_from_empty_list_has_no_recommendations() {
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationReport.from(Collections.<UsabilityDefect> emptyList());
        assertThat(evaluationReport).isNotNull().has(noUsabilityGuidlineRecommendations());
    }

    @Test
    public void usability_report_from_non_empty_list_has_recommendations() {
        List<UsabilityDefect> guidlineRecommendations =
            Lists
                .newArrayList(new UsabilityDefectFactory(
                                                         new DummyUsabilityGuidlineDescriptionResolver())
                    .createUsabilityGuidlineRecommendation(UsabilityDefectSeverityLevel.INFO,
                                                           new DummyUsabilityRuleset()
                                                               .evaluationRules().iterator().next(),
                                                           Collections.<String, String> emptyMap()));
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationReport.from(guidlineRecommendations);
        assertThat(evaluationReport).isNotNull().has(usabilityGuidlineRecommendations());
    }

}
