//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.EnumSet;
import java.util.List;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRule;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRuleset;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityEvaluationFacade {

    private UsabilityEvaluationFacade() {
        // no instantiation allowed
    }

    public static ExecuteUsabilityEvaluationStep applyUsabilityRuleset(UsabilityRuleset usabilityRuleset)
    {
        Preconditions.checkNotNull(usabilityRuleset);
        return new ExecuteUsabilityEvaluationStep(usabilityRuleset);
    }

    protected static class ExecuteUsabilityEvaluationStep {

        protected ExecuteUsabilityEvaluationStep(UsabilityRuleset usabilityRuleset) {
            super();
            this.usabilityRuleset = usabilityRuleset;
        }

        private final UsabilityRuleset usabilityRuleset;

        public UsabilityEvaluationReport evaluateUsabilityOf(ITaskTree taskTree) {
            Preconditions.checkNotNull(taskTree);
            EnumSet<? extends UsabilityRule> evaluationRules = usabilityRuleset.evaluationRules();
            List<UsabilityDefect> evaluationResults =
                Lists.newArrayListWithCapacity(evaluationRules.size());
            for (UsabilityRule usabilityRule : evaluationRules) {
                Optional<UsabilityDefect> ruleEvaluationResult = usabilityRule.evaluate(taskTree);
                if (ruleEvaluationResult.isPresent()) {
                    evaluationResults.add(ruleEvaluationResult.get());
                }
            }
            return UsabilityEvaluationReport.from(evaluationResults);
        }

    }

}
