package de.ugoe.cs.autoquest.eventcore.guimodel;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * Test of {@link GUIElementTree}
 * @author Fabian Glaser
 *
 */
public class GUIElementTreeTest {

    @Test
    public void testAdd() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        IGUIElementSpec spec = new MockGUIElementSpec();
        tree.add(10l, null, spec);
        
        assertEquals(1, tree.size());
    }
    
    @Test
    public void testAddWithParent() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        IGUIElementSpec parentspec = new MockGUIElementSpec();
        IGUIElementSpec spec = new MockGUIElementSpec();
        tree.add(10l, null, parentspec);
        tree.add(20l, 10l, spec);
        
        assertEquals(2, tree.size());
        
        IGUIElement element = tree.find(20l);
        assertEquals(parentspec, element.getParent().getSpecification());
    }

    @Test
    public void testFindExisting() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        IGUIElementSpec spec = new MockGUIElementSpec();
        tree.add(10l, 0l, spec);
        
        IGUIElement element = tree.find(10l);
        assertNotNull(element);
    }
    
    @Test
    public void testFindNonExisting() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        assertEquals(tree.find(10l), null);
    }

    @Test
    public void testRemoveSingleElement() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        IGUIElementSpec spec = new MockGUIElementSpec(); 
        tree.add(10l, null, spec);
        
        assertEquals(1, tree.size());
        assertEquals(1, tree.remove(10l));
    }
    
    @Test
    public void testRemoveWithChildElement() throws Exception {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        IGUIElementSpec parentspec = new MockGUIElementSpec();
        IGUIElementSpec spec = new MockGUIElementSpec();
        tree.add(10l, null, parentspec);
        tree.add(20l, 10l, spec);
        
        assertEquals(2, tree.remove(10l));
        assertEquals(0, tree.size());
    }
    
    @Test
    public void testRemoveNonExisting(){
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        assertEquals(0, tree.remove(10l));
    }

    @Test
    public void testGetGUIModel() {
        GUIElementTree<Long> tree = new GUIElementTree<Long>();
        assertNotNull(tree.getGUIModel());
    }
}
