//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.testutil;

import java.util.Collections;
import java.util.EnumSet;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectSeverityLevel;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectFactory;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRule;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRuleset;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class DummyUsabilityRuleset implements UsabilityRuleset {

    private enum DummyUsabilityRule implements UsabilityRule {

        DUMMY_RULE_WITH_RECOMMENDATION {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return Optional
                    .of(new UsabilityDefectFactory(new DummyUsabilityGuidlineDescriptionResolver())
                        .createUsabilityGuidlineRecommendation(UsabilityDefectSeverityLevel.INFO,
                                                               this, Collections
                                                                   .<String, String> emptyMap()));
            }

            public String ruleIdentifier() {
                return this.name();
            }

        },

        DUMMY_RULE_WITHOUT_RECOMMENDATION {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return Optional.absent();
            }

            public String ruleIdentifier() {
                return this.name();
            }
        };

        public abstract Optional<UsabilityDefect> evaluate(ITaskTree taskTree);

    }

    private final EnumSet<DummyUsabilityRule> DUMMY_USABILITY_RULESET = EnumSet
        .allOf(DummyUsabilityRule.class);

    public EnumSet<? extends UsabilityRule> evaluationRules() {
        return DUMMY_USABILITY_RULESET;
    }

}
