//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.evaluation.rule.set;

import java.util.EnumSet;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.NoLetterOrDigitTextInputsEvaluator;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.TextInputEntryRepetitionsEvaluator;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.TextInputRatioEvaluator;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class TextInputUsabiliyRuleset implements UsabilityRuleset {

    private enum TextInputUsabilityRule implements UsabilityRule {

        TEXT_FIELD_INPUT_RATIO {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new TextInputRatioEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }

        },

        TEXT_FIELD_INPUT_REPETITIONS {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new TextInputEntryRepetitionsEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }

        },

        TEXT_FIELD_NO_LETTER_OR_DIGIT_RATIO {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new NoLetterOrDigitTextInputsEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }

        };

        public abstract Optional<UsabilityDefect> evaluate(ITaskTree taskTree);

    }

    private final EnumSet<TextInputUsabilityRule> TEXT_INPUT_USABILITY_RULESET = EnumSet
        .allOf(TextInputUsabilityRule.class);

    @Override
    public EnumSet<? extends UsabilityRule> evaluationRules() {
        return TEXT_INPUT_USABILITY_RULESET;
    }

}
