//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.gui.IInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.MouseInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.TextInput;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public enum EventTypeFilter implements TaskTreeNodeFilter<IEventType> {

    MOUSE_BUTTON_INTERACTION(MouseButtonInteraction.class),
    
    MOUSE_INTERACTION(MouseInteraction.class),
    
    TEXT_INPUT(TextInput.class),
    
    USER_INTERACTION(IInteraction.class);

    private Class<? extends IEventType> eventTypeClazz;

    private EventTypeFilter(Class<? extends IEventType> eventTypeClazz) {
        this.eventTypeClazz = eventTypeClazz;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<IEventType> clazz() {
        return (Class<IEventType>) eventTypeClazz;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Predicate filterPredicate() {
        Predicate<Object> instanceOfIEventTaskPredicate = Predicates.instanceOf(IEventTask.class);
        Predicate<ITaskTreeNode> nodeHoldsInstanceOfFilterArgument =
            Predicates.compose(Predicates.instanceOf(eventTypeClazz), nodeExtractionFunction());
        return Predicates.and(instanceOfIEventTaskPredicate, nodeHoldsInstanceOfFilterArgument);
    }

    private Function<ITaskTreeNode, IEventType> nodeExtractionFunction() {
        return new Function<ITaskTreeNode, IEventType>() {

            @Override
            public IEventType apply(ITaskTreeNode treeNode) {
                return ((IEventTask) treeNode).getEventType();
            }
        };
    }
}
