//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree.filter;

import com.google.common.base.Preconditions;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class TaskTreeFilter {

    private final TaskTreeFilterStrategy taskTreeFilterStrategy;

    public TaskTreeFilter(TaskTreeFilterStrategy treeTraversalStrategy) {
        Preconditions.checkNotNull(treeTraversalStrategy);
        this.taskTreeFilterStrategy = treeTraversalStrategy;
    }

    public FilterEventTargetStep filterByEventTarget(EventTargetFilter eventTarget) {
        return new FilterEventTargetStep(eventTarget);
    }

    public FilterEventTypeStep filterByEventType(EventTypeFilter eventType) {
        return new FilterEventTypeStep(eventType);
    }

    public FilterNodeTypeStep filterByNodeType(TaskTreeNodeTypeFilter nodeType) {
        return new FilterNodeTypeStep(nodeType);
    }

    public class FilterEventTargetStep {

        private final EventTargetFilter eventTarget;

        public FilterEventTargetStep(EventTargetFilter eventTarget) {
            this.eventTarget = eventTarget;
        }

        public FilterStatistic from(ITaskTree taskTree) {
            return taskTreeFilterStrategy.filter(taskTree, eventTarget);
        }

    }

    public class FilterEventTypeStep {

        private final EventTypeFilter eventType;

        public FilterEventTypeStep(EventTypeFilter eventType) {
            this.eventType = eventType;
        }

        public FilterStatistic from(ITaskTree taskTree) {
            return taskTreeFilterStrategy.filter(taskTree, eventType);
        }

    }

    public class FilterNodeTypeStep {

        private final TaskTreeNodeTypeFilter nodeType;

        public FilterNodeTypeStep(TaskTreeNodeTypeFilter nodeType) {
            this.nodeType = nodeType;
        }

        public FilterStatistic from(ITaskTree taskTree) {
            return taskTreeFilterStrategy.filter(taskTree, nodeType);
        }

    }
}
