//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import de.ugoe.cs.util.console.CommandExecuter;

/**
 * TODO comment
 *
 * @author Steffen Herbold, Patrick Harms
 */
public class SWTHelpers {

    /**
     * 
     */
    public static boolean deleteSelectedFromStorage(final List list) {
        String[] selectedStrings = list.getSelection();
        if (selectedStrings.length == 0) {
            return false;
        }
        else {
            for (String selected : selectedStrings) {
                String command = "deleteObject " + selected;
                CommandExecuter.getInstance().exec(command);
            }
            return true;
        }
    }

    /**
     * 
     */
    public static void noSelectionError(final Shell shell) {
        MessageBox messageBox = new MessageBox(shell, SWT.ERROR);
        messageBox.setMessage
            ("No objects selected! Please select at least one object to execute this function");
        messageBox.setText("Error");
        messageBox.open();
    }

    /**
     *
     */
    public static void moreThanOneSelectedError(final Shell shell) {
        MessageBox messageBox = new MessageBox(shell, SWT.ERROR);
        messageBox.setMessage("Too many objects selected for this function! Select only one!");
        messageBox.setText("Error");
        messageBox.open();
    }

}
