//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.sequences;

import java.util.List;

import de.ugoe.cs.autoquest.CommandHelpers;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command to condense the GUI model of a sequence, i.e., merge duplicate nodes.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public class CMDcondenseGuiModel implements Command {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#run(java.util.List)
     */
    @Override
    public void run(List<Object> parameters) {
        String sequencesName = "sequences";

        if (parameters.size() > 0) {
            sequencesName = (String) parameters.get(0);
        }

        Object dataObject = GlobalDataContainer.getInstance().getData(sequencesName + "_targets");
        if (dataObject == null) {
            CommandHelpers.objectNotFoundMessage(sequencesName + "_targets");
            return;
        }
        if (!(dataObject instanceof GUIModel)) {
            CommandHelpers.objectNotType(sequencesName, "GUIModel");
            return;
        }

        GUIModel model = (GUIModel) dataObject;

        model.condenseModel();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.util.console.Command#help()
     */
    @Override
    public String help() {
        return "condenseGuiModel {<sequencesName>}";
    }

}
