//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class DefaultGuiEventSequenceDetectionRuleTest extends AbstractTemporalRelationshipTC {
    
    /**
     *
     */
    @Test
    public void test_01() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("end", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event start {}" +
             "  Event end {}" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }
    
    
    /**
     *
     */
    @Test
    public void test_02() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("end", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event start {}" +
             "  Event bla {}" +
             "  Event end {}" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }
    
    /**
     *
     */
    @Test
    public void test_03() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("end", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("end", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event start {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blup {}" +
             "    Event end {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event start {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event end {}" +
             "  }" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }
    
    /**
     *
     */
    @Test
    public void test_04() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartAndFinishSequenceInteraction("startFinish", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new StartAndFinishSequenceInteraction("startFinish", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new StartAndFinishSequenceInteraction("startFinish", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event startFinish {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blup {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event startFinish {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "  }" +
             "  Event startFinish {}" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }

    /**
     *
     */
    @Test
    public void test_05() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event start {}" +
             "    Event bla {}" +
             "    Sequence sequence2 {" +
             "      Event start {}" +
             "      Sequence sequence3 {" +
             "        Event start {}" +
             "        Event bli {}" +
             "        Event blup {}" +
             "        Event finish {}" +
             "      }" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event finish {}" +
             "    }" +
             "    Sequence sequence4 {" +
             "      Event start {}" +
             "      Sequence sequence5 {" +
             "        Event start {}" +
             "        Sequence sequence6 {" +
             "          Event start {}" +
             "          Event blup {}" +
             "          Event finish {}" +
             "        }" +
             "        Event finish {}" +
             "      }" +
             "      Event finish {}" +
             "    }" +
             "    Event finish {}" +
             "  }" +
             "  Event finish {}" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }

    /**
     *
     */
    @Test
    public void test_06() {
        IGUIElement elem1 = new DummyGUIElement("elem1");
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new StartAndFinishSequenceInteraction("startFinish", 1), elem1);
        simulateEvent(new DummyInteraction("bla", 1), elem1);
        simulateEvent(new DummyInteraction("bli", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new StartSequenceInteraction("start", 1), elem1);
        simulateEvent(new DummyInteraction("blup", 1), elem1);
        simulateEvent(new StartAndFinishSequenceInteraction("startFinish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);
        simulateEvent(new FinishSequenceInteraction("finish", 1), elem1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event start {}" +
             "    Event bla {}" +
             "    Sequence sequence2 {" +
             "      Event start {}" +
             "      Sequence sequence3 {" +
             "        Event start {}" +
             "        Event bli {}" +
             "        Event blup {}" +
             "      }" +
             "      Sequence sequence4 {" +
             "        Event startFinish {}" +
             "        Event bla {}" +
             "        Event bli {}" +
             "        Event finish {}" +
             "      }" +
             "      Sequence sequence5 {" +
             "        Event start {}" +
             "        Sequence sequence6 {" +
             "          Event start {}" +
             "          Sequence sequence7 {" +
             "            Event start {}" +
             "            Event blup {}" +
             "          }" +
             "          Sequence sequence8 {" +
             "            Event startFinish {}" +
             "            Event finish {}" +
             "          }" +
             "          Event finish {}" +
             "        }" +
             "        Event finish {}" +
             "      }" +
             "      Event finish {}" +
             "    }" +
             "    Event finish {}" +
             "  }" +
             "  Event finish {}" +
             "}", getTaskTree(DefaultGuiEventSequenceDetectionRule.class, null));
    }
    
    /**
     *
     */
    private class StartSequenceInteraction extends DummyInteraction {

        /**  */
        private static final long serialVersionUID = 1L;

        /**
         *
         */
        public StartSequenceInteraction(String interactionType, int interactionNumber) {
            super(interactionType, interactionNumber);
        }

        /* (non-Javadoc)
         * @see de.ugoe.cs.autoquest.test.DummyInteraction#startsLogicalSequence()
         */
        @Override
        public boolean startsLogicalSequence() {
            return true;
        }
        
    }

    /**
     *
     */
    private class FinishSequenceInteraction extends DummyInteraction {

        /**  */
        private static final long serialVersionUID = 1L;

        /**
         *
         */
        public FinishSequenceInteraction(String interactionType, int interactionNumber) {
            super(interactionType, interactionNumber);
        }
 
        /* (non-Javadoc)
         * @see de.ugoe.cs.autoquest.test.DummyInteraction#finishesLogicalSequence()
         */
        @Override
        public boolean finishesLogicalSequence() {
            return true;
        }
       
    }

    /**
     *
     */
    private class StartAndFinishSequenceInteraction extends DummyInteraction {

        /**  */
        private static final long serialVersionUID = 1L;

        /**
         *
         */
        public StartAndFinishSequenceInteraction(String interactionType, int interactionNumber) {
            super(interactionType, interactionNumber);
        }
 
        /* (non-Javadoc)
         * @see de.ugoe.cs.autoquest.test.DummyInteraction#startsLogicalSequence()
         */
        @Override
        public boolean startsLogicalSequence() {
            return true;
        }
        
        /* (non-Javadoc)
         * @see de.ugoe.cs.autoquest.test.DummyInteraction#finishesLogicalSequence()
         */
        @Override
        public boolean finishesLogicalSequence() {
            return true;
        }
       
    }
}
