//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.usageprofiles.SymbolComparator;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class TaskTreeNodeComparator implements SymbolComparator<ITaskTreeNode> {
    
    /**
     * <p>
     * the node equality manager needed for comparing task tree nodes with each other
     * </p>
     */
    private NodeEqualityRuleManager nodeEqualityRuleManager;

    /**
     * <p>
     * the minimal node equality two identified sublists need to have to consider them as equal
     * and to create an iteration for
     * </p>
     */
    private NodeEquality minimalNodeEquality;



    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param nodeEqualityRuleManager
     * @param minimalNodeEquality
     */
    public TaskTreeNodeComparator(NodeEqualityRuleManager nodeEqualityRuleManager,
                                  NodeEquality            minimalNodeEquality)
    {
        super();
        this.nodeEqualityRuleManager = nodeEqualityRuleManager;
        this.minimalNodeEquality = minimalNodeEquality;
    }



    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.temporalrelation.SymbolComparator#equals(java.lang.Object, java.lang.Object)
     */
    @Override
    public boolean equals(ITaskTreeNode symbol1, ITaskTreeNode symbol2) {
        return nodeEqualityRuleManager.applyRules(symbol1, symbol2).isAtLeast(minimalNodeEquality);
    }

}
