//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class Iteration extends TaskTreeNode implements IIteration {

    /**
     *
     */
    Iteration() {
        super("Iteration");
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNode#addChild(TaskTreeNode)
     */
    @Override
    public void addChild(ITaskTreeNode child) {
        // adding more children is not allowed
        throw new UnsupportedOperationException
          ("iterations may not have a list of children. Use setChild() instead.");
    }

    /**
     * TODO: comment
     * 
     * @param selection
     * @return
     */
    public void setChild(ITaskTreeNode child) {
        if (super.getChildren().size() > 0) {
            super.removeChild(0);
        }
        super.addChild(child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public Iteration clone() {
        return (Iteration) super.clone();
    }

}
