//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * This rule identifies two task tree nodes as lexically equal, if they are both event tasks and
 * if their respective event types and targets equal. 
 * </p>
 * 
 * @author Patrick Harms
 */
public class EventTaskComparisonRule implements NodeComparisonRule {
    
    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.nodeequality.NodeEqualityRule#apply(TaskTreeNode, TaskTreeNode)
     */
    @Override
    public NodeEquality compare(ITaskTreeNode node1, ITaskTreeNode node2) {
        if ((!(node1 instanceof IEventTask)) || (!(node2 instanceof IEventTask))) {
            return null;
        }

        if (node1 == node2) {
            return NodeEquality.IDENTICAL;
        }

        IEventTask task1 = (IEventTask) node1;
        IEventTask task2 = (IEventTask) node2;
        
        if (task1.getEventType().equals(task2.getEventType()) &&
            task1.getEventTarget().equals(task2.getEventTarget()))
        {
            return NodeEquality.LEXICALLY_EQUAL;
        }
        else {
            return NodeEquality.UNEQUAL;
        }
    }

}
