//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class TaskTreeNode implements ITaskTreeNode {
    /** */
    private static int temporalId = 0;

    /** */
    private String name;

    /** */
    private String description;

    /** */
    private int id;

    /** children */
    private List<ITaskTreeNode> children;

    /**
     * 
     */
    public TaskTreeNode(String name) {
        this.name = name;
        id = getNewId();
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    private static synchronized int getNewId() {
        if (temporalId == Integer.MAX_VALUE) {
            temporalId = 0;
        }

        return temporalId++;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNode#getDescription()
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * 
     */
    public synchronized List<ITaskTreeNode> getChildren() {
        if ((children == null) || (children.size() == 0)) {
            return new ArrayList<ITaskTreeNode>();
        }

        return children.subList(0, children.size());
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.TaskTreeNode#equals(TaskTreeNode)
     */
    @Override
    public boolean equals(ITaskTreeNode taskTreeNode) {
        if (!this.getClass().isInstance(taskTreeNode)) {
            return false;
        }

        if (taskTreeNode.hashCode() != hashCode()) {
            return false;
        }

        TaskTreeNode other = (TaskTreeNode) taskTreeNode;

        if (id != other.id) {
            return false;
        }

        if (!name.equals(other.name)) {
            return false;
        }

        synchronized (other) {
            if (children == null) {
                return (other.children == null);
            }
            else if (other.children == null) {
                return (children == null);
            }
            else if (other.children.size() != children.size()) {
                return false;
            }

            for (int i = 0; i < children.size(); i++) {
                if (!children.get(i).equals(other.children.get(i))) {
                    return false;
                }
            }
        }

        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public synchronized int hashCode() {
        return getClass().getSimpleName().hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        if (children == null) {
            return name + "(" + id + ")";
        }
        else {
            return name + "(" + id + ", " + children.size() + " children)";
        }
    }

    /**
     * TODO: comment
     * 
     * @param i
     * @return
     */
    void setDescription(String description) {
        this.description = description;
    }

    /**
     * 
     */
    synchronized void addChild(ITaskTreeNode child) {
        if (children == null) {
            children = new ArrayList<ITaskTreeNode>();
        }

        children.add(child);
    }

    /**
     * 
     */
    synchronized void addChild(int index, ITaskTreeNode child) {
        if (children == null) {
            children = new ArrayList<ITaskTreeNode>();
        }

        children.add(index, child);
    }

    /**
     * TODO: comment
     * 
     * @param i
     * @return
     */
    synchronized ITaskTreeNode removeChild(int index) {
        return children.remove(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    @Override
    public synchronized ITaskTreeNode clone() {
        TaskTreeNode clone = null;
        try {
            clone = (TaskTreeNode) super.clone();

            if (children != null) {
                clone.children = new ArrayList<ITaskTreeNode>();

                for (ITaskTreeNode child : children) {
                    clone.children.add(child.clone());
                }
            }

        }
        catch (CloneNotSupportedException e) {
            // this should never happen. Therefore simply dump the exception
            e.printStackTrace();
        }

        return clone;
    }

}
