//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.evaluation.rule.set;

import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.emptyUsabilityRuleset;
import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.textInputUsabiliyRuleset;
import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.mouseInteractionUsabiliyRuleset;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.noUsabilityRules;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.usabilityRules;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class RulesetFactoryTest {

    @Test
    public void empty_ruleset_factory_method_should_return_empty_ruleset() {
        UsabilityRuleset ruleset = emptyUsabilityRuleset();
        assertThat(ruleset).isInstanceOf(EmptyUsabilityRuleset.class).has(noUsabilityRules());
    }

    @Test
    public void text_input_ruleset_factory_method_should_return_text_input_ruleset() {
        UsabilityRuleset ruleset = textInputUsabiliyRuleset();
        assertThat(ruleset).isInstanceOf(TextInputUsabiliyRuleset.class).has(usabilityRules());
    }

    @Test
    public void mouse_interaction_ruleset_factory_method_should_return_mouse_interaction_ruleset() {
        UsabilityRuleset ruleset = mouseInteractionUsabiliyRuleset();
        assertThat(ruleset).isInstanceOf(MouseInteractionUsabilityRuleset.class)
            .has(usabilityRules());
    }

}
