//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private String type;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param type
     * @param index
     * @param id
     */
    public HTMLGUIElementSpec(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }

        this.type = type;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getType()
     */
    @Override
    public String getType() {
        return type;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLGUIElementSpec) {
            HTMLGUIElementSpec otherSpec = (HTMLGUIElementSpec) other;
            return type.equals(otherSpec.type);
        }
        
        return false;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     */
    @Override
    public String[] getTypeHierarchy() {
        return new String[] { type };
    }

}
