//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeInfo;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class NodeInfo implements ITaskTreeNodeInfo {
    
    /** */
    private ITaskTreeNode task;

    /** */
    private long lastUpdate;

    /** */
    private List<ITaskTreeNode> parentNodes = new ArrayList<ITaskTreeNode>();

    /**
     * @param node
     */
    NodeInfo(ITaskTreeNode task) {
        this.task = task;
        lastUpdate = System.currentTimeMillis();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.NodeInfo#getTask()
     */
    @Override
    public ITaskTreeNode getTask() {
        return task;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getNoOfOccurencesInTree()
     */
    @Override
    public int getNoOfOccurencesInTree() {
        return parentNodes.size();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeimpl.NodeInfo#getLastUpdate()
     */
    @Override
    public long getLastUpdate() {
        return lastUpdate;
    }

    /**
     * TODO: comment
     * 
     */
    void addParent(ITaskTreeNode parent) {
        parentNodes.add(parent);
    }

    /**
     * TODO: comment
     * 
     */
    void removeParent(ITaskTreeNode parent) {
        parentNodes.remove(parent);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public synchronized String toString() {
        return "NodeInfo(" + task + ", " + parentNodes.size() + " parents)";
    }

}
