/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassSummary;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.TestCaseDetector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindUnrelatedTypesInGenericContainer
implements Detector {
    private BugReporter bugReporter;
    private static final boolean DEBUG = SystemProperties.getBoolean("gc.debug");
    private MultiMap<String, Info> callMap = new MultiMap(LinkedList.class);
    static final HashSet<String> baseGenericTypes = new HashSet();

    private void addCheckedCall(@DottedClassName String className, String methodName, String sig, int argumentParameterIndex, int typeParameterIndex) {
        ClassDescriptor c = DescriptorFactory.instance().getClassDescriptorForDottedClassName(className);
        String call = methodName + sig;
        Info info = new Info(c, argumentParameterIndex, typeParameterIndex);
        this.callMap.add(call, info);
    }

    private void addCheckedCall(@DottedClassName String className, String methodName, int typeParameterIndex) {
        this.addCheckedCall(className, methodName, "(Ljava/lang/Object;)", 0, typeParameterIndex);
    }

    public FindUnrelatedTypesInGenericContainer(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.addCheckedCall(Collection.class.getName(), "contains", 0);
        this.addCheckedCall(Collection.class.getName(), "remove", 0);
        this.addCheckedCall(Collection.class.getName(), "containsAll", "(Ljava/util/Collection;)", 0, -1);
        this.addCheckedCall(Collection.class.getName(), "removeAll", "(Ljava/util/Collection;)", 0, -1);
        this.addCheckedCall(Collection.class.getName(), "retainAll", "(Ljava/util/Collection;)", 0, -1);
        this.addCheckedCall("java.util.Deque", "removeFirstOccurrence", 0);
        this.addCheckedCall("java.util.Deque", "removeLastOccurrence", 0);
        this.addCheckedCall(List.class.getName(), "indexOf", 0);
        this.addCheckedCall(List.class.getName(), "lastIndexOf", 0);
        this.addCheckedCall(Vector.class.getName(), "indexOf", "(Ljava/lang/Object;I)", 0, 0);
        this.addCheckedCall(Vector.class.getName(), "lastIndexOf", "(Ljava/lang/Object;I)", 0, 0);
        this.addCheckedCall(Map.class.getName(), "containsKey", 0);
        this.addCheckedCall(Map.class.getName(), "containsValue", 1);
        this.addCheckedCall(Map.class.getName(), "get", 0);
        this.addCheckedCall(Map.class.getName(), "remove", 0);
        this.addCheckedCall(Hashtable.class.getName(), "contains", 1);
        this.addCheckedCall(ConcurrentHashMap.class.getName(), "contains", 1);
        this.addCheckedCall(ConcurrentMap.class.getName(), "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall(ConcurrentMap.class.getName(), "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Multimap", "containsEntry", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Multimap", "containsEntry", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Multimap", "containsKey", 0);
        this.addCheckedCall("com.google.common.collect.Multimap", "containsValue", 1);
        this.addCheckedCall("com.google.common.collect.Multimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Multimap", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Multimap", "removeAll", 0);
        this.addCheckedCall("com.google.common.cache.Cache", "invalidate", 0);
        this.addCheckedCall("com.google.common.collect.Multiset", "count", 0);
        this.addCheckedCall("com.google.common.collect.Multiset", "remove", "(Ljava/lang/Object;I)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Table", "contains", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Table", "contains", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Table", "containsRow", 0);
        this.addCheckedCall("com.google.common.collect.Table", "containsColumn", 1);
        this.addCheckedCall("com.google.common.collect.Table", "containsValue", 2);
        this.addCheckedCall("com.google.common.collect.Table", "get", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Table", "get", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Table", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 0, 0);
        this.addCheckedCall("com.google.common.collect.Table", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)", 1, 1);
        this.addCheckedCall("com.google.common.collect.Sets", "intersection", "(Ljava/util/Set;Ljava/util/Set;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Sets", "difference", "(Ljava/util/Set;Ljava/util/Set;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Sets", "symmetricDifference", "(Ljava/util/Set;Ljava/util/Set;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterables", "contains", "(Ljava/lang/Iterable;Ljava/lang/Object;)", 1, 0);
        this.addCheckedCall("com.google.common.collect.Iterables", "removeAll", "(Ljava/lang/Iterable;Ljava/util/Collection;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterables", "retainAll", "(Ljava/lang/Iterable;Ljava/util/Collection;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterables", "elementsEqual", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterables", "frequency", "(Ljava/lang/Iterable;Ljava/lang/Object;)", 1, 0);
        this.addCheckedCall("com.google.common.collect.Iterators", "contains", "(Ljava/util/Iterator;Ljava/lang/Object;)", 1, 0);
        this.addCheckedCall("com.google.common.collect.Iterators", "removeAll", "(Ljava/util/Iterator;Ljava/util/Collection;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterators", "retainAll", "(Ljava/util/Iterator;Ljava/util/Collection;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterators", "elementsEqual", "(Ljava/util/Iterator;Ljava/util/Iterator;)", 1, -1);
        this.addCheckedCall("com.google.common.collect.Iterators", "frequency", "(Ljava/util/Iterator;Ljava/lang/Object;)", 1, 0);
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            String msg;
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException e) {
            }
            catch (CFGBuilderException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
            catch (DataflowAnalysisException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(185) || bytecodeSet.get(182) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(183));
    }

    private boolean isSynthetic(Method m) {
        Attribute[] attrs;
        if ((m.getAccessFlags() & 0x1000) != 0) {
            return true;
        }
        for (Attribute attr : attrs = m.getAttributes()) {
            if (!(attr instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private boolean isGenericCollection(ClassDescriptor operandClass) {
        String dottedClassName = operandClass.getDottedClassName();
        if (baseGenericTypes.contains(dottedClassName)) {
            return true;
        }
        String found = null;
        for (String c : baseGenericTypes) {
            if (!Subtypes2.instanceOf(operandClass, c)) continue;
            found = c;
            break;
        }
        if (found == null) {
            return false;
        }
        if (dottedClassName.startsWith("java.util.") || dottedClassName.startsWith("com.google.common.collect.")) {
            return true;
        }
        try {
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, operandClass);
            String sig = xclass.getSourceSignature();
            if (sig == null) {
                return false;
            }
            List<String> split = GenericUtilities.split(sig, true);
            for (String s : split) {
                int i = s.indexOf(60);
                if (i < 0) continue;
                if (s.charAt(0) != 'L') {
                    throw new IllegalStateException("unexpected non signature: " + s);
                }
                ClassDescriptor c = DescriptorFactory.createClassDescriptor(s.substring(1, i));
                if (!this.isGenericCollection(c)) continue;
                if (DEBUG) {
                    System.out.println(operandClass + " is a subtype of " + s);
                }
                return true;
            }
        }
        catch (CheckedAnalysisException e1) {
            AnalysisContext.logError("Error checking for weird generic parameterization of " + operandClass, e1);
        }
        return false;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (this.isSynthetic(method) || !this.prescreen(classContext, method)) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod(classContext.getJavaClass(), method);
        if (xmethod.isSynthetic()) {
            return;
        }
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        ValueNumberDataflow vnDataflow = classContext.getValueNumberDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        String fullMethodName = methodGen.getClassName() + "." + methodGen.getName();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (DEBUG) {
            System.out.println("Checking " + fullMethodName);
        }
        Iterator<Location> iter = cfg.locationIterator();
        while (iter.hasNext()) {
            Location location = iter.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            XMethod invokedMethod = XFactory.createXMethod(inv, cpg);
            String invokedMethodName = invokedMethod.getName();
            String argSignature = invokedMethod.getSignature();
            argSignature = argSignature.substring(0, argSignature.indexOf(41) + 1);
            String call = invokedMethodName + argSignature;
            SignatureParser sigParser = new SignatureParser(inv.getSignature(cpg));
            Collection<Info> collection = this.callMap.get(call);
            if (!this.callMap.containsKey(call)) continue;
            for (Info info : collection) {
                XMethod nextMethod;
                Instruction nextIns;
                InstructionHandle next;
                GenericObjectType p2;
                List<? extends ReferenceType> parameters;
                boolean selfOperation;
                Type actualType;
                ClassDescriptor operandClass;
                Type objectType;
                ValueNumber argVN;
                Type operandType;
                int typeArgument;
                boolean allMethod;
                block33: {
                    Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                    if (DEBUG) {
                        System.out.println("at " + handle.getPosition() + " Checking call to " + info.interfaceForCall + " : " + invokedMethod);
                    }
                    try {
                        if (!subtypes2.isSubtype(invokedMethod.getClassDescriptor(), info.interfaceForCall)) {
                        }
                        break block33;
                    }
                    catch (ClassNotFoundException e) {
                        if (info.interfaceForCall.getClassName().equals("java/util/Collection") && invokedMethod.getClassName().equals("com.google.common.collect.Multiset")) break block33;
                        AnalysisContext.reportMissingClass(e);
                    }
                    continue;
                }
                if (info.typeIndex >= 0) {
                    allMethod = false;
                    typeArgument = info.typeIndex;
                } else {
                    allMethod = true;
                    typeArgument = -(1 + info.typeIndex);
                }
                int pos = info.argumentIndex;
                int lhsPos = inv instanceof INVOKESTATIC ? sigParser.getSlotsFromTopOfStackForParameter(0) : sigParser.getTotalArgumentSize();
                int stackPos = sigParser.getSlotsFromTopOfStackForParameter(pos);
                TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                if (!frame.isValid() || (operandType = (Type)frame.getStackValue(stackPos)).equals(TopType.instance()) || operandType.equals(NullType.instance())) continue;
                ValueNumberFrame vnFrame = (ValueNumberFrame)vnDataflow.getFactAtLocation(location);
                if (!vnFrame.isValid()) {
                    AnalysisContext.logError("Invalid value number frame in " + xmethod);
                    continue;
                }
                ValueNumber objectVN = (ValueNumber)vnFrame.getStackValue(lhsPos);
                if (objectVN.equals(argVN = (ValueNumber)vnFrame.getStackValue(stackPos))) {
                    XMethod nextMethod2;
                    Instruction nextIns2;
                    InstructionHandle next2;
                    String bugPattern = "DMI_COLLECTIONS_SHOULD_NOT_CONTAIN_THEMSELVES";
                    int priority = 1;
                    if (invokedMethodName.equals("removeAll")) {
                        bugPattern = "DMI_USING_REMOVEALL_TO_CLEAR_COLLECTION";
                        priority = 2;
                    } else if (invokedMethodName.endsWith("All")) {
                        bugPattern = "DMI_VACUOUS_SELF_COLLECTION_CALL";
                        priority = 2;
                    }
                    if (invokedMethodName.startsWith("contains") && (next2 = handle.getNext()) != null && (nextIns2 = next2.getInstruction()) instanceof InvokeInstruction && (nextMethod2 = XFactory.createXMethod((InvokeInstruction)nextIns2, cpg)).getName().equals("assertFalse")) continue;
                    accumulator.accumulateBug(new BugInstance(this, bugPattern, priority).addClassAndMethod(methodGen, sourceFile).addCalledMethod(methodGen, (InvokeInstruction)ins).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, objectVN, vnFrame, "INVOKED_ON")), SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle));
                }
                if (!((objectType = (Type)frame.getStackValue(lhsPos)) instanceof GenericObjectType)) continue;
                GenericObjectType operand = (GenericObjectType)objectType;
                int expectedTypeParameters = 1;
                String simpleName = info.interfaceForCall.getSimpleName();
                if (simpleName.toLowerCase().endsWith("map") || simpleName.equals("Hashtable")) {
                    expectedTypeParameters = 2;
                } else if (simpleName.equals("Table")) {
                    expectedTypeParameters = 3;
                }
                if (!operand.hasParameters() || operand.getNumParameters() != expectedTypeParameters || !this.isGenericCollection(operandClass = DescriptorFactory.getClassDescriptor(operand))) continue;
                Type expectedType = allMethod ? operand : operand.getParameterAt(typeArgument);
                Type equalsType = actualType = (Type)frame.getStackValue(stackPos);
                if (allMethod) {
                    if (!(actualType instanceof GenericObjectType)) continue;
                    equalsType = ((GenericObjectType)actualType).getParameterAt(typeArgument);
                }
                IncompatibleTypes matchResult = this.compareTypes(expectedType, actualType, allMethod);
                boolean parmIsObject = expectedType.getSignature().equals("Ljava/lang/Object;");
                boolean bl = selfOperation = !allMethod && operand.equals(actualType) && !parmIsObject;
                if (!allMethod && !parmIsObject && actualType instanceof GenericObjectType && (parameters = (p2 = (GenericObjectType)actualType).getParameters()) != null && ((Object)parameters).equals(operand.getParameters())) {
                    selfOperation = true;
                }
                if (!selfOperation && (matchResult == IncompatibleTypes.SEEMS_OK || matchResult.getPriority() == 5) || (invokedMethodName.startsWith("contains") || invokedMethodName.equals("remove") ? (next = handle.getNext()) != null && (nextIns = next.getInstruction()) instanceof InvokeInstruction && (nextMethod = XFactory.createXMethod((InvokeInstruction)nextIns, cpg)).getName().equals("assertFalse") : (invokedMethodName.equals("get") || invokedMethodName.equals("remove")) && (next = handle.getNext()) != null && (nextIns = next.getInstruction()) instanceof InvokeInstruction && (nextMethod = XFactory.createXMethod((InvokeInstruction)nextIns, cpg)).getName().equals("assertNull"))) continue;
                boolean noisy = false;
                if (invokedMethodName.equals("get")) {
                    UnconditionalValueDerefDataflow unconditionalValueDerefDataflow = classContext.getUnconditionalValueDerefDataflow(method);
                    UnconditionalValueDerefSet unconditionalDeref = (UnconditionalValueDerefSet)unconditionalValueDerefDataflow.getFactAtLocation(location);
                    ValueNumberFrame vnAfter = (ValueNumberFrame)vnDataflow.getFactAfterLocation(location);
                    ValueNumber top = (ValueNumber)vnAfter.getTopValue();
                    noisy = unconditionalDeref.getValueNumbersThatAreUnconditionallyDereferenced().contains(top);
                }
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
                if (expectedType instanceof GenericObjectType) {
                    expectedType = ((GenericObjectType)expectedType).getUpperBound();
                }
                int priority = matchResult.getPriority();
                if (!operandClass.getClassName().startsWith("java/util") && priority == 1) {
                    priority = Math.max(priority, 2);
                }
                if (TestCaseDetector.likelyTestCase(xmethod)) {
                    priority = Math.max(priority, 2);
                } else if (selfOperation) {
                    priority = 1;
                }
                ClassDescriptor expectedClassDescriptor = DescriptorFactory.createClassOrObjectDescriptorFromSignature(expectedType.getSignature());
                ClassDescriptor actualClassDescriptor = DescriptorFactory.createClassOrObjectDescriptorFromSignature(equalsType.getSignature());
                ClassSummary classSummary = AnalysisContext.currentAnalysisContext().getClassSummary();
                Set<XMethod> targets = null;
                try {
                    targets = Hierarchy2.resolveVirtualMethodCallTargets(actualClassDescriptor, "equals", "(Ljava/lang/Object;)Z", false, false);
                    boolean allOk = targets.size() > 0;
                    for (XMethod m2 : targets) {
                        if (classSummary.mightBeEqualTo(m2.getClassDescriptor(), expectedClassDescriptor)) continue;
                        allOk = false;
                    }
                    if (allOk) {
                        priority += 2;
                    }
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
                String bugPattern = "GC_UNRELATED_TYPES";
                BugInstance bug = new BugInstance(this, bugPattern, priority).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(actualType, expectedType).addCalledMethod(methodGen, (InvokeInstruction)ins).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, objectVN, vnFrame, "INVOKED_ON")).addOptionalAnnotation(ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, argVN, vnFrame, "ARGUMENT")).addEqualsMethodUsed(targets);
                if (noisy) {
                    WarningPropertySet<GeneralWarningProperty> propertySet = new WarningPropertySet<GeneralWarningProperty>();
                    propertySet.addProperty(GeneralWarningProperty.NOISY_BUG);
                    propertySet.decorateBugInstance(bug);
                }
                accumulator.accumulateBug(bug, sourceLineAnnotation);
            }
        }
        accumulator.reportAccumulatedBugs();
    }

    private IncompatibleTypes compareTypes(Type expectedType, Type actualType, boolean ignoreBaseType) {
        String actualString;
        if (expectedType == actualType) {
            return IncompatibleTypes.SEEMS_OK;
        }
        String expectedString = GenericUtilities.getString(expectedType);
        if (expectedString.equals(actualString = GenericUtilities.getString(actualType))) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (expectedType.equals(Type.OBJECT)) {
            return IncompatibleTypes.SEEMS_OK;
        }
        String objString = GenericUtilities.getString(Type.OBJECT);
        if (expectedString.equals(objString)) {
            return IncompatibleTypes.SEEMS_OK;
        }
        GenericUtilities.TypeCategory expectedCat = GenericUtilities.getTypeCategory(expectedType);
        GenericUtilities.TypeCategory argCat = GenericUtilities.getTypeCategory(actualType);
        if (actualString.equals(objString) && expectedCat == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (ignoreBaseType) {
            if (expectedCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
                GenericObjectType parmGeneric = (GenericObjectType)expectedType;
                GenericObjectType argGeneric = (GenericObjectType)actualType;
                return this.compareTypeParameters(parmGeneric, argGeneric);
            }
            return IncompatibleTypes.SEEMS_OK;
        }
        if (actualType.equals(Type.OBJECT) && expectedCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            return IncompatibleTypes.ARRAY_AND_OBJECT;
        }
        if (expectedCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE && argCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE) {
            return IncompatibleTypes.getPriorityForAssumingCompatible(expectedType, actualType, false);
        }
        if (expectedCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE) {
            return IncompatibleTypes.getPriorityForAssumingCompatible((GenericObjectType)expectedType, actualType);
        }
        if (expectedCat == GenericUtilities.TypeCategory.PLAIN_OBJECT_TYPE && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
            return IncompatibleTypes.getPriorityForAssumingCompatible((GenericObjectType)actualType, expectedType);
        }
        if (expectedCat == GenericUtilities.TypeCategory.WILDCARD_EXTENDS || expectedCat == GenericUtilities.TypeCategory.WILDCARD_SUPER) {
            return this.compareTypes(((GenericObjectType)expectedType).getExtension(), actualType, ignoreBaseType);
        }
        if (expectedCat == GenericUtilities.TypeCategory.TYPE_VARIABLE || argCat == GenericUtilities.TypeCategory.TYPE_VARIABLE) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (expectedCat == GenericUtilities.TypeCategory.ARRAY_TYPE && argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            ArrayType parmArray = (ArrayType)expectedType;
            ArrayType argArray = (ArrayType)actualType;
            if (parmArray.getDimensions() != argArray.getDimensions()) {
                return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
            }
            return this.compareTypes(parmArray.getBasicType(), argArray.getBasicType(), ignoreBaseType);
        }
        if (expectedCat == GenericUtilities.TypeCategory.ARRAY_TYPE ^ argCat == GenericUtilities.TypeCategory.ARRAY_TYPE) {
            return IncompatibleTypes.ARRAY_AND_NON_ARRAY;
        }
        if (expectedCat == GenericUtilities.TypeCategory.PARAMETERIZED && argCat == GenericUtilities.TypeCategory.PARAMETERIZED) {
            GenericObjectType parmGeneric = (GenericObjectType)expectedType;
            GenericObjectType argGeneric = (GenericObjectType)actualType;
            IncompatibleTypes result = this.compareTypes(parmGeneric.getObjectType(), argGeneric.getObjectType(), ignoreBaseType);
            if (!result.equals(IncompatibleTypes.SEEMS_OK)) {
                return result;
            }
            return this.compareTypeParameters(parmGeneric, argGeneric);
        }
        if (expectedCat == GenericUtilities.TypeCategory.WILDCARD) {
            return IncompatibleTypes.SEEMS_OK;
        }
        if (expectedType instanceof BasicType || actualType instanceof BasicType) {
            throw new IllegalArgumentException("checking for compatibility of " + expectedType + " with " + actualType);
        }
        return IncompatibleTypes.SEEMS_OK;
    }

    private IncompatibleTypes compareTypeParameters(GenericObjectType parmGeneric, GenericObjectType argGeneric) {
        int p = parmGeneric.getNumParameters();
        if (p != argGeneric.getNumParameters()) {
            return IncompatibleTypes.SEEMS_OK;
        }
        for (int x = 0; x < p; ++x) {
            IncompatibleTypes result = this.compareTypes(parmGeneric.getParameterAt(x), argGeneric.getParameterAt(x), false);
            if (result == IncompatibleTypes.SEEMS_OK) continue;
            return result;
        }
        return IncompatibleTypes.SEEMS_OK;
    }

    private boolean compareTypesOld(Type parmType, Type argType) {
        GenericObjectType o;
        if (GenericUtilities.getString(parmType).equals(GenericUtilities.getString(argType))) {
            return true;
        }
        if (parmType instanceof GenericObjectType && (o = (GenericObjectType)parmType).getTypeCategory() == GenericUtilities.TypeCategory.WILDCARD_EXTENDS) {
            return this.compareTypesOld(o.getExtension(), argType);
        }
        if (parmType instanceof GenericObjectType && !((GenericObjectType)parmType).hasParameters()) {
            return true;
        }
        if (argType instanceof GenericObjectType && !((GenericObjectType)argType).hasParameters()) {
            return true;
        }
        if (parmType instanceof GenericObjectType && argType instanceof GenericObjectType) {
            return true;
        }
        if (!(parmType instanceof ReferenceType) || !(argType instanceof ReferenceType)) {
            return true;
        }
        if (!(parmType instanceof ObjectType) || !(argType instanceof ObjectType)) {
            return true;
        }
        try {
            return Repository.instanceOf(((ObjectType)argType).getClassName(), ((ObjectType)parmType).getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public void report() {
    }

    static {
        baseGenericTypes.addAll(Arrays.asList("java.util.Map", "java.util.Collection", "java.lang.Iterable", "java.util.Iterator", "com.google.common.collect.Multimap", "com.google.common.collect.Multiset", "com.google.common.collect.Table"));
    }

    static class Info {
        final ClassDescriptor interfaceForCall;
        final int argumentIndex;
        final int typeIndex;

        public Info(ClassDescriptor interfaceForCall, int argumentIndex, int typeIndex) {
            this.interfaceForCall = interfaceForCall;
            this.argumentIndex = argumentIndex;
            this.typeIndex = typeIndex;
        }

        public String toString() {
            return String.format("[%s %d %d]", this.interfaceForCall, this.argumentIndex, this.typeIndex);
        }
    }
}

