//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * A node comparison rule is used by the {@link NodeEqualityRuleManager} to compare task tree
 * nodes with each other. It provides one method to be called for a comparison.
 * </p>
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public interface NodeComparisonRule {

    /**
     * <p>
     * compares two nodes with each other. The result of the method is either a node equality or
     * null. If it is null, it means, that the rule is not able to correctly compare the two given
     * nodes
     * </p>
     * 
     * @param node1 the first task tree node to compare
     * @param node2 the second task tree node to compare
     * 
     * @return as described
     */
    public NodeEquality compare(ITaskTreeNode node1, ITaskTreeNode node2);

}
