//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
class RuleUtils {
    
    /** */
    private static int idCounter = 0;

    /**
     * 
     */
    static ISequence createNewSubSequenceInRange(ITaskTreeNode         parent,
                                                 int                   startIndex,
                                                 int                   endIndex,
                                                 String                description,
                                                 ITaskTreeNodeFactory  nodeFactory,
                                                 ITaskTreeBuilder      builder)
    {
        ISequence sequence = nodeFactory.createNewSequence();
        if (description != null) {
            builder.setDescription(sequence, description);
        }

        for (int i = startIndex; i <= endIndex; i++) {
            builder.addChild(sequence, parent.getChildren().get(startIndex));
            builder.removeChild((ISequence) parent, startIndex);
        }

        builder.addChild((ISequence) parent, startIndex, sequence);

        return sequence;
    }

    /**
     *
     */
    public static synchronized String getNewId() {
        return Integer.toString(idCounter++);
    }

    /**
     *
     */
    private RuleUtils() {
        // prevent instantiation
    }

}
