//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class SimpleIterationDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testInteractionIterationDetection() throws Exception {
        IEventTarget element1 = new DummyGUIElement("elem1");
        IEventType event1 = new DummyInteraction("bla", 1);
        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Event bla {}" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

        simulateEvent(event1, element1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

        // now test with preceding and trailing other events
        IEventType event2 = new DummyInteraction("bli", 1);
        IEventType event3 = new DummyInteraction("blup", 1);

        simulateEvent(event2, element1);
        simulateEvent(event3, element1);
        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, element1);
        }
        simulateEvent(event3, element1);
        simulateEvent(event2, element1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration2 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

        // now test with iterations of iterations

        for (int i = 0; i < 5; i++) {
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event2, element1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event3, element1);
            }
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration2 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "  Iteration iteration4 {" +
             "    Event bla {}" +
             "  }" +
             "  Iteration iteration5 {" +
             "    Event bli {}" +
             "  }" +
             "  Iteration iteration6 {" +
             "    Event blup {}" +
             "  }" +
             "  Iteration iteration7 {" +
             "    Event bla {}" +
             "  }" +
             "  Iteration iteration8 {" +
             "    Event bli {}" +
             "  }" +
             "  Iteration iteration9 {" +
             "    Event blup {}" +
             "  }" +
             "  Iteration iteration10 {" +
             "    Event bla {}" +
             "  }" +
             "  Iteration iteration11 {" +
             "    Event bli {}" +
             "  }" +
             "  Iteration iteration12 {" +
             "    Event blup {}" +
             "  }" +
             "  Iteration iteration13 {" +
             "    Event bla {}" +
             "  }" +
             "  Iteration iteration14 {" +
             "    Event bli {}" +
             "  }" +
             "  Iteration iteration15 {" +
             "    Event blup {}" +
             "  }" +
             "  Iteration iteration16 {" +
             "    Event bla {}" +
             "  }" +
             "  Iteration iteration17 {" +
             "    Event bli {}" +
             "  }" +
             "  Iteration iteration18 {" +
             "    Event blup {}" +
             "  }" +
             "}", getTaskTree(SimpleIterationDetectionRule.class, null));

    }

}
