//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import java.util.ArrayList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * The rule application result describes the result of applying a {@link TemporalRelationshipRule}
 * on a task tree node. It contains a {@link RuleApplicationStatus} and a list of all parent
 * task tree nodes that were created during a rule application. See the description of
 * {@link TemporalRelationshipRule} for more details.
 * </p>
 * 
 * @author Patrick Harms
 */
class RuleApplicationResult {

    /** */
    private RuleApplicationStatus status = RuleApplicationStatus.NOT_APPLIED;

    /** */
    private List<ITaskTreeNode> newParents = new ArrayList<ITaskTreeNode>();

    /**
     * <p>
     * create a rule application result with a status {@link RuleApplicationStatus#RULE_NOT_APPLIED}
     * </p>
     */
    RuleApplicationResult() {
        // this is the default indicating nothing so far
    }

    /**
     * <p>
     * set the rule application status
     * </p>
     */
    void setRuleApplicationStatus(RuleApplicationStatus status) {
        this.status = status;
    }

    /**
     * <p>
     * return the rule application status
     * </p>
     */
    RuleApplicationStatus getRuleApplicationStatus() {
        return status;
    }

    /**
     * <p>
     * add a further parent node created during the rule application
     * </p>
     */
    void addNewlyCreatedParentNode(ITaskTreeNode newParent) {
        newParents.add(newParent);
    }

    /**
     * <p>
     * return all parent nodes created during the rule application
     * </p>
     */
    List<ITaskTreeNode> getNewlyCreatedParentNodes() {
        return newParents;
    }

}
