//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TaskTreeBuilder implements ITaskTreeBuilder {

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, TaskTreeNode)
     */
    @Override
    public void addChild(ISequence parent, ITaskTreeNode child) {
        if (!(parent instanceof Sequence)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, -1, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, int, TaskTreeNode)
     */
    @Override
    public void addChild(ISequence parent, int index, ITaskTreeNode child) {
        if (!(parent instanceof Sequence)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, index, child);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder#setChild(de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence, int, de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode)
     */
    @Override
    public void setChild(ISequence parent, int index, ITaskTreeNode child) {
        if (!(parent instanceof Sequence)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        ((TaskTreeNode) parent).removeChild(index);
        addChildInternal(parent, index, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Selection, TaskTreeNode)
     */
    @Override
    public void addChild(ISelection parent, ITaskTreeNode child) {
        if (!(parent instanceof Selection)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        addChildInternal(parent, -1, child);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setChild(Iteration, TaskTreeNode)
     */
    @Override
    public void setChild(IIteration iteration, ITaskTreeNode newChild) {
        if (!(iteration instanceof Iteration)) {
            throw new IllegalArgumentException
                ("illegal type of iteration provided: " + iteration.getClass());
        }

        if (!(newChild instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + newChild.getClass());
        }

        ((Iteration) iteration).setChild(newChild);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder#setChild(de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional, de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode)
     */
    @Override
    public void setChild(IOptional optional, ITaskTreeNode newChild) {
        if (!(optional instanceof Optional)) {
            throw new IllegalArgumentException
                ("illegal type of optional provided: " + optional.getClass());
        }

        if (!(newChild instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + newChild.getClass());
        }

        ((Optional) optional).setChild(newChild);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Sequence, int)
     */
    @Override
    public void removeChild(ISequence parent, int index) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        ((TaskTreeNode) parent).removeChild(index);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Selection, TaskTreeNode)
     */
    @Override
    public void removeChild(ISelection parent, ITaskTreeNode child) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        List<ITaskTreeNode> children = parent.getChildren();
        
        for (int i = 0; i < children.size(); i++) {
            if ((children.get(i) == child) ||
                ((children.get(i) != null) && (children.get(i).equals(child))))
            {
                ((TaskTreeNode) parent).removeChild(i);
                break;
            }
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder#replaceChild(de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection, de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode, de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode)
     */
    @Override
    public void replaceChild(ISelection parent, ITaskTreeNode oldChild, ITaskTreeNode newChild) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        List<ITaskTreeNode> children = parent.getChildren();
        
        for (int i = 0; i < children.size(); i++) {
            if ((children.get(i) == oldChild) ||
                ((children.get(i) != null) && (children.get(i).equals(oldChild))))
            {
                ((TaskTreeNode) parent).removeChild(i);
                ((TaskTreeNode) parent).addChild(i, newChild);
                break;
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setDescription(TaskTreeNode, String)
     */
    @Override
    public void setDescription(ITaskTreeNode parent, String description) {
        if (!(parent instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + parent.getClass());
        }

        ((TaskTreeNode) parent).setDescription(description);
    }

    /**
     * 
     */
    private void addChildInternal(ITaskTreeNode parent, int index, ITaskTreeNode child) {
        if (!(child instanceof TaskTreeNode)) {
            throw new IllegalArgumentException
                ("illegal type of task tree node provided: " + child.getClass());
        }

        if (index > -1) {
            ((TaskTreeNode) parent).addChild(index, child);
        }
        else {
            ((TaskTreeNode) parent).addChild(child);
        }
    }

}
