//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.gui.IInteraction;
import de.ugoe.cs.autoquest.tasktrees.TaskTreeChecker;
import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;
import de.ugoe.cs.autoquest.test.DummyGUIElement;
import de.ugoe.cs.autoquest.test.DummyInteraction;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class SequenceForTaskDetectionRuleTest extends AbstractTemporalRelationshipTC {

    /**
     *
     */
    @Test
    public void testTaskDetection() throws Exception {
        IEventTarget element1 = new DummyGUIElement("elem1");
        
        IInteraction action1 = new DummyInteraction("action1", 1);
        IInteraction action2 = new DummyInteraction("action2", 1);
        IInteraction action3 = new DummyInteraction("action3", 1);
        IInteraction action4 = new DummyInteraction("action4", 1);
        
        simulateEvent(new DummyInteraction("noise0", 1), element1);
        simulateEvent(action1, element1);
        simulateEvent(action2, element1);
        simulateEvent(action3, element1);
        simulateEvent(action4, element1);
        simulateEvent(new DummyInteraction("noise1", 1), element1);
        simulateEvent(new DummyInteraction("noise2", 1), element1);
        simulateEvent(action1, element1);
        simulateEvent(action2, element1);
        simulateEvent(action3, element1);
        simulateEvent(action4, element1);
        simulateEvent(new DummyInteraction("noise3", 1), element1);
        simulateEvent(new DummyInteraction("noise4", 1), element1);
        simulateEvent(new DummyInteraction("noise5", 1), element1);
        simulateEvent(new DummyInteraction("noise6", 1), element1);
        simulateEvent(action1, element1);
        simulateEvent(action2, element1);
        simulateEvent(action3, element1);
        simulateEvent(action4, element1);
        simulateEvent(new DummyInteraction("noise7", 1), element1);
        simulateEvent(new DummyInteraction("noise8", 1), element1);
        
        new TaskTreeChecker(true).assertTaskTree
            ("Sequence root {" +
             "  Sequence session1 {" +
             "    Event noise0 {}" +
             "    Sequence sequence2 {" +
             "      Event action1 {}" +
             "      Event action2 {}" +
             "      Event action3 {}" +
             "      Event action4 {}" +
             "    }" +
             "    Event noise1 {}" +
             "    Event noise2 {}" +
             "    Sequence sequence2 {" +
             "      Event action1 {}" +
             "      Event action2 {}" +
             "      Event action3 {}" +
             "      Event action4 {}" +
             "    }" +
             "    Event noise3 {}" +
             "    Event noise4 {}" +
             "    Event noise5 {}" +
             "    Event noise6 {}" +
             "    Sequence sequence2 {" +
             "      Event action1 {}" +
             "      Event action2 {}" +
             "      Event action3 {}" +
             "      Event action4 {}" +
             "    }" +
             "    Event noise7 {}" +
             "    Event noise8 {}" +
             "  }" +
             "}", getTaskTree(SequenceForTaskDetectionRule.class, NodeEquality.LEXICALLY_EQUAL));

    }

}
