//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.manager;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TemporalRelationshipRuleManager;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 12.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class ComponentManager {
    
    /** */
    private static ComponentManager instance;

    /** */
    private TemporalRelationshipRuleManager temporalRelationshipRuleManager;

    /** */
    private NodeEqualityRuleManager nodeEqualityRuleManager;

    /** */
    private ITaskTreeBuilder taskTreeBuilder;

    /** */
    private ITaskTreeNodeFactory taskTreeNodeFactory;

    /**
     *
     */
    public static TemporalRelationshipRuleManager getTemporalRelationshipRuleManager() {
        return getInstance().temporalRelationshipRuleManager;
    }

    /**
     *
     */
    public static NodeEqualityRuleManager getNodeEqualityRuleManager() {
        return getInstance().nodeEqualityRuleManager;
    }

    /**
     *
     */
    public static ITaskTreeBuilder getDefaultTaskTreeBuilder() {
        return getInstance().taskTreeBuilder;
    }

    /**
     *
     */
    public static ITaskTreeNodeFactory getDefaultTaskTreeNodeFactory() {
        return getInstance().taskTreeNodeFactory;
    }

    /**
     * 
     */
    public static synchronized void clearInstance() {
        instance = null;
    }

    /**
     *
     */
    private static synchronized ComponentManager getInstance() {
        if (instance == null) {
            instance = new ComponentManager();
            instance.init();
        }
        return instance;
    }

    /**
     * 
     */
    private void init() {
        nodeEqualityRuleManager = new NodeEqualityRuleManager();
        nodeEqualityRuleManager.init();

        taskTreeBuilder = new TaskTreeBuilder();
        taskTreeNodeFactory = new TaskTreeNodeFactory();

        temporalRelationshipRuleManager = new TemporalRelationshipRuleManager
            (nodeEqualityRuleManager, taskTreeNodeFactory, taskTreeBuilder);
        temporalRelationshipRuleManager.init();
    }

}
