//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TaskTreeNodeFactory implements ITaskTreeNodeFactory {

    /*
     * (non-Javadoc)
     * 
     * @see TaskTreeNodeFactory#createNewEventTask(IEventType, IEventTarget)
     */
    @Override
    public IEventTask createNewEventTask(IEventType eventType, IEventTarget eventTarget) {
        return new EventTask(eventType, eventTarget);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSequence()
     */
    @Override
    public ISequence createNewSequence() {
        return new Sequence();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewIteration()
     */
    @Override
    public IIteration createNewIteration() {
        return new Iteration();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNodeFactory#createNewOptional()
     */
    @Override
    public IOptional createNewOptional() {
        return new Optional();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSelection()
     */
    @Override
    public ISelection createNewSelection() {
        return new Selection();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createTaskTree(de.ugoe.cs.tasktree.treeifc
     * .TaskTreeNode)
     */
    @Override
    public ITaskTree createTaskTree(ITaskTreeNode root) {
        return new TaskTree(root);
    }

}
