//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree;

import java.util.LinkedList;
import java.util.Queue;

import com.google.common.base.Predicate;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.usability.tasktree.filters.EventTargetFilter;
import de.ugoe.cs.autoquest.usability.tasktree.filters.EventTypeFilter;
import de.ugoe.cs.autoquest.usability.tasktree.filters.TaskTreeNodeTypeFilter;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class IterativeDFSFilterStrategy implements TaskTreeFilterStrategy {

    private FilterResult filterStatistic;

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskTree taskTree, EventTargetFilter eventTarget) {
        Predicate<IEventTarget> filterPredicate = eventTarget.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskTree taskTree, EventTypeFilter eventType) {
        Predicate<IEventType> filterPredicate = eventType.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterResult filter(ITaskTree taskTree, TaskTreeNodeTypeFilter nodeType) {
        Predicate<ITaskTreeNode> filterPredicate = nodeType.filterPredicate();
        this.filterStatistic = new FilterResult(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    private void traverse(ITaskTree taskTree) {
        Queue<ITaskTreeNode> unvisitedNodes = new LinkedList<ITaskTreeNode>();
        unvisitedNodes.add(taskTree.getRoot());
        while (stillUnvisitedNodes(unvisitedNodes)) {
            ITaskTreeNode node = unvisitedNodes.poll();
            processCurrentNode(node);
            processChildrenOfCurrentNode(unvisitedNodes, node);
        }
    }

    private boolean stillUnvisitedNodes(Queue<ITaskTreeNode> unvisitedNodes) {
        return !unvisitedNodes.isEmpty();
    }

    private void processCurrentNode(ITaskTreeNode node) {
        this.filterStatistic.addNode(node);
    }

    private void processChildrenOfCurrentNode(Queue<ITaskTreeNode> unvisitedNodes,
                                              ITaskTreeNode node)
    {
        for (ITaskTreeNode child : node.getChildren()) {
            unvisitedNodes.add(child);
        }
    }

}
