//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.List;

import com.google.common.base.Preconditions;

import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityEvaluationReport {

    private List<UsabilityDefect> evaluationResults;

    private UsabilityEvaluationReport(List<UsabilityDefect> evaluationResults) {
        this.evaluationResults = evaluationResults;
    }

    public static UsabilityEvaluationReport from(List<UsabilityDefect> evaluationResults) {
        Preconditions.checkNotNull(evaluationResults);
        return new UsabilityEvaluationReport(evaluationResults);
    }

    public List<UsabilityDefect> evaluationResults() {
        return this.evaluationResults;
    }

}
