//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree.filter;

import java.util.Stack;

import com.google.common.base.Predicate;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class IterativeDFSFilterStrategy implements TaskTreeFilterStrategy {

    private FilterStatistic filterStatistic;

    @SuppressWarnings("unchecked")
    @Override
    public FilterStatistic filter(ITaskTree taskTree, EventTargetFilter eventTarget) {
        Predicate<IEventTarget> filterPredicate = eventTarget.filterPredicate();
        this.filterStatistic = new FilterStatistic(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterStatistic filter(ITaskTree taskTree, EventTypeFilter eventType) {
        Predicate<IEventType> filterPredicate = eventType.filterPredicate();
        this.filterStatistic = new FilterStatistic(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    @SuppressWarnings("unchecked")
    @Override
    public FilterStatistic filter(ITaskTree taskTree, TaskTreeNodeTypeFilter nodeType) {
        Predicate<ITaskTreeNode> filterPredicate = nodeType.filterPredicate();
        this.filterStatistic = new FilterStatistic(filterPredicate);
        traverse(taskTree);
        return this.filterStatistic;
    }

    private void traverse(ITaskTree taskTree) {
        Stack<ITaskTreeNode> unvisitedNodes = new Stack<ITaskTreeNode>();
        unvisitedNodes.push(taskTree.getRoot());
        while (stillUnvisitedNodes(unvisitedNodes)) {
            ITaskTreeNode node = unvisitedNodes.pop();
            processCurrentNode(node);
            processChildrenOfCurrentNode(unvisitedNodes, node);
        }
    }

    private boolean stillUnvisitedNodes(Stack<ITaskTreeNode> unvisitedNodes) {
        return !unvisitedNodes.isEmpty();
    }

    private void processCurrentNode(ITaskTreeNode node) {
        this.filterStatistic.addNode(node);
    }

    private void processChildrenOfCurrentNode(Stack<ITaskTreeNode> unvisitedNodes,
                                              ITaskTreeNode node)
    {
        for (ITaskTreeNode child : node.getChildren()) {
            unvisitedNodes.push(child);
        }
    }

}
