//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
class RuleUtils {
    
    /** */
    private static int idCounter = 0;

    /**
     * 
     */
    static ITaskInstance getSubSequenceInRange(ITaskInstanceList parent,
                                               int               startIndex,
                                               int               endIndex,
                                               ITask             model,
                                               ITaskFactory      taskFactory,
                                               ITaskBuilder      taskBuilder)
    {
        ITaskInstance subsequence = taskFactory.createNewTaskInstance(model);

        for (int i = startIndex; i <= endIndex; i++) {
            taskBuilder.addChild(subsequence, parent.get(i));
        }

        return subsequence;
    }

    /**
     * 
     */
    static ITaskInstance createNewSubSequenceInRange(ITaskInstanceList parent,
                                                     int               startIndex,
                                                     int               endIndex,
                                                     ITask             model,
                                                     ITaskFactory      taskFactory,
                                                     ITaskBuilder      taskBuilder)
    {
        ITaskInstance subsequence = taskFactory.createNewTaskInstance(model);

        for (int i = startIndex; i <= endIndex; i++) {
            taskBuilder.addChild(subsequence, parent.get(startIndex));
            taskBuilder.removeTaskInstance(parent, startIndex);
        }


        taskBuilder.addTaskInstance(parent, startIndex, subsequence);

        return subsequence;
    }

    /**
     *
     */
    static synchronized String getNewId() {
        return Integer.toString(idCounter++);
    }

    /**
     *
     */
    private RuleUtils() {
        // prevent instantiation
    }

}
