//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules;

import java.util.List;

import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.rules.metrics.NoLetterOrDigitRatioMetric;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputEntryRepetitionsMetric;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputRatioMetric;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityMetricsRuleset implements UsabilityRuleset {

    private List<UsabilityRule> metrics;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     */
    private UsabilityMetricsRuleset(ITaskTree taskTree) {
        this.metrics = Lists.newArrayList();
        metrics.add(new NoLetterOrDigitRatioMetric(taskTree));
        metrics.add(new TextInputEntryRepetitionsMetric(taskTree));
        metrics.add(new TextInputRatioMetric(taskTree));
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usability.UsabilityRuleset#evaluationRules()
     */
    @Override
    public List<UsabilityRule> evaluationRules() {
        return this.metrics;
    }

}
