//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.manager;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.util.console.Console;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class TaskTreeManager {
    
    /** */
    private ITaskBuilder taskBuilder = ComponentManager.getDefaultTaskBuilder();

    /** */
    private ITaskFactory taskFactory = ComponentManager.getDefaultTaskFactory();

    /** */
    private List<IUserSession> sessions = null;

    /** */
    private IUserSession currentSession = null;

    /**
     *
     */
    public TaskTreeManager() {
        sessions = new LinkedList<IUserSession>();
    }

    /**
     *
     */
    public synchronized ITaskModel createTaskModel(Collection<List<Event>> newSessions) {
        if ((currentSession != null) || (sessions.size() > 0)) {
            throw new IllegalStateException("do not mix calls to this method with calls to the " +
                                            "other methods for handling tasks. Use only one " +
                                            "variant instead.");
        }
        
        for (List<Event> newSession : newSessions) {
            if (newSession.size() > 0) {
                for (Event event : newSession) {
                    handleNewEvent(event);
                }
                finishSession();
            }
        }
        
        return getTaskModel();
    }

    /**
     *
     */
    public void handleNewEvent(Event event) {
        assertSessionSequence();
        ITask eventTask = taskFactory.createNewEventTask(event.getType(), event.getTarget());
        taskBuilder.addExecutedTask(currentSession, taskFactory.createNewTaskInstance(eventTask));
    }

    /**
     * 
     */
    public void finishSession() {
        if ((currentSession != null) && (currentSession.getExecutedTasks().size() > 0)) {
            sessions.add(currentSession);
            currentSession = null;
        }
    }

    /**
     *
     */
    public synchronized ITaskModel getTaskModel() {
        finishSession();
        
        Console.traceln(Level.INFO, "applying temporal relationship generation rules");
        
        ComponentManager.getTemporalRelationshipRuleManager().applyRules(sessions);

        return taskFactory.createTaskModel(sessions);
    }

    /**
     *
     */
    private void assertSessionSequence() {
        if (currentSession == null) {
            currentSession = taskFactory.createUserSession();
        }
    }

}
