/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.detect.DeadLocalStoreProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindDeadLocalStores
implements Detector {
    private static final boolean DEBUG = SystemProperties.getBoolean("fdls.debug");
    private static final String FINDBUGS_EXCLUDED_LOCALS_PROP_NAME = "findbugs.dls.exclusions";
    private static final Set<String> EXCLUDED_LOCALS = new HashSet<String>();
    private static final boolean DO_EXCLUDE_LOCALS = SystemProperties.getProperty("findbugs.dls.exclusions") != null;
    private static final boolean SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE;
    private static final BitSet defensiveConstantValueOpcodes;
    private BugReporter bugReporter;

    public FindDeadLocalStores(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            System.out.println("Debugging FindDeadLocalStores detector");
        }
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        return true;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        if (method.isSynthetic() || (method.getAccessFlags() & 64) == 64) {
            return;
        }
        if (FindDeadLocalStores.DEBUG) {
            System.out.println("    Analyzing method " + classContext.getJavaClass().getClassName() + "." + method.getName());
        }
        javaClass = classContext.getJavaClass();
        linesMentionedMultipleTimes = classContext.linesMentionedMultipleTimes(method);
        accumulator = new BugAccumulator(this.bugReporter);
        llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
        numLocals = method.getCode().getMaxLocals();
        localStoreCount = new int[numLocals];
        localLoadCount = new int[numLocals];
        localIncrementCount = new int[numLocals];
        methodGen = classContext.getMethodGen(method);
        cfg = classContext.getCFG(method);
        if (cfg.isFlagSet(32)) {
            return;
        }
        liveStoreSetAtEntry = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getResultFact(cfg.getEntry());
        complainedAbout = new BitSet();
        typeDataflow = classContext.getTypeDataflow(method);
        localsThatAreParameters = PreorderVisitor.getNumberArguments(method.getSignature());
        if (!method.isStatic()) {
            ++localsThatAreParameters;
        }
        this.countLocalStoresLoadsAndIncrements(localStoreCount, localLoadCount, localIncrementCount, cfg);
        i = 0;
        while (i < localsThatAreParameters) {
            v0 = i++;
            localStoreCount[v0] = localStoreCount[v0] + 1;
        }
        liveStoreSourceLineSet = new BitSet();
        i = cfg.locationIterator();
        while (i.hasNext()) {
            block78: {
                block79: {
                    block77: {
                        block75: {
                            block76: {
                                block73: {
                                    block74: {
                                        block72: {
                                            block71: {
                                                block70: {
                                                    block68: {
                                                        block69: {
                                                            block67: {
                                                                location = i.next();
                                                                pendingBugReportAboutOverwrittenParameter = null;
                                                                propertySet = new WarningPropertySet<WarningProperty>();
                                                                if (this.isStore(location)) break block67;
                                                                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                                                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                                                continue;
                                                            }
                                                            if (location.getBasicBlock().isExceptionHandler()) {
                                                                propertySet.addProperty(DeadLocalStoreProperty.EXCEPTION_HANDLER);
                                                            }
                                                            handle = location.getHandle();
                                                            pc = handle.getPosition();
                                                            ins = (IndexedInstruction)location.getHandle().getInstruction();
                                                            local = ins.getIndex();
                                                            liveStoreSet = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getFactAtLocation(location);
                                                            storeLive = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSet, local);
                                                            lvAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation(method, location, ins);
                                                            sourceFileName = javaClass.getSourceFileName();
                                                            if (!lvAnnotation.getName().equals("?")) break block68;
                                                            if (!sourceFileName.endsWith(".groovy")) break block69;
                                                            if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                                            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                                            continue;
                                                        }
                                                        if (method.getCode().getLocalVariableTable() == null) break block68;
                                                        if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                                        this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                                        continue;
                                                    }
                                                    sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFileName, location.getHandle());
                                                    if (FindDeadLocalStores.DEBUG) {
                                                        System.out.println("    Store at " + sourceLineAnnotation.getStartLine() + "@" + location.getHandle().getPosition() + " is " + (storeLive != false ? "live" : "dead"));
                                                        System.out.println("Previous is: " + location.getHandle().getPrev());
                                                    }
                                                    if (storeLive && sourceLineAnnotation.getStartLine() > 0) {
                                                        liveStoreSourceLineSet.set(sourceLineAnnotation.getStartLine());
                                                    }
                                                    if ((lvName = lvAnnotation.getName()).charAt(0) == '$' || lvName.charAt(0) == '_') {
                                                        propertySet.addProperty(DeadLocalStoreProperty.SYNTHETIC_NAME);
                                                    }
                                                    if (!FindDeadLocalStores.EXCLUDED_LOCALS.contains(lvName)) break block70;
                                                    if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                                    continue;
                                                }
                                                propertySet.setProperty(DeadLocalStoreProperty.LOCAL_NAME, lvName);
                                                v1 = isParameter = local < localsThatAreParameters;
                                                if (isParameter) {
                                                    propertySet.addProperty(DeadLocalStoreProperty.IS_PARAMETER);
                                                }
                                                shadowedField = null;
                                                for (Field f : javaClass.getFields()) {
                                                    if (!f.getName().equals(lvName) || f.isStatic() != method.isStatic()) continue;
                                                    shadowedField = f;
                                                    propertySet.addProperty(DeadLocalStoreProperty.SHADOWS_FIELD);
                                                    break;
                                                }
                                                v2 = parameterThatIsDeadAtEntry = isParameter != false && ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSetAtEntry, local) == false;
                                                if (parameterThatIsDeadAtEntry && !complainedAbout.get(local)) {
                                                    v3 = priority = storeLive != false ? 3 : 2;
                                                    if (shadowedField != null) {
                                                        --priority;
                                                    }
                                                    pendingBugReportAboutOverwrittenParameter = new BugInstance(this, "IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN", priority).addClassAndMethod(methodGen, sourceFileName).add(lvAnnotation);
                                                    if (shadowedField != null) {
                                                        pendingBugReportAboutOverwrittenParameter.addField(FieldAnnotation.fromBCELField(classContext.getJavaClass(), shadowedField)).describe("FIELD_DID_YOU_MEAN");
                                                    }
                                                    pendingBugReportAboutOverwrittenParameter.addSourceLine(classContext, methodGen, sourceFileName, location.getHandle());
                                                    complainedAbout.set(local);
                                                }
                                                if (!storeLive) break block71;
                                                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                                continue;
                                            }
                                            typeFrame = (TypeFrame)((TypeAnalysis)typeDataflow.getAnalysis()).getFactAtLocation(location);
                                            typeOfValue = null;
                                            if (typeFrame.isValid() && typeFrame.getStackDepth() > 0) {
                                                typeOfValue = (Type)typeFrame.getTopValue();
                                            }
                                            storeOfNull = false;
                                            prevInsHandle = location.getHandle().getPrev();
                                            if (prevInsHandle == null) ** GOTO lbl188
                                            prevIns = prevInsHandle.getInstruction();
                                            foundDeadClassInitialization = false;
                                            initializationOf = null;
                                            if (!(prevIns instanceof ConstantPushInstruction)) break block72;
                                            if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                            continue;
                                        }
                                        try {
                                            if (prevIns instanceof GETSTATIC) {
                                                getStatic = (GETSTATIC)prevIns;
                                                cpg = methodGen.getConstantPool();
                                                foundDeadClassInitialization = getStatic.getFieldName(cpg).startsWith("class$") != false && getStatic.getSignature(cpg).equals("Ljava/lang/Class;") != false;
                                                j = cfg.locationIterator();
                                                while (j.hasNext()) {
                                                    location2 = j.next();
                                                    if (location2.getHandle().getPosition() + 15 != location.getHandle().getPosition() || !((instruction2 = location2.getHandle().getInstruction()) instanceof LDC) || !((value = ((LDC)instruction2).getValue(methodGen.getConstantPool())) instanceof String) || (n = (String)value).length() <= 0) continue;
                                                    initializationOf = ClassName.toSignature(n);
                                                }
                                                break block73;
                                            }
                                            if (!(prevIns instanceof LDC)) ** GOTO lbl157
                                            ldc = (LDC)prevIns;
                                            t = ldc.getType(methodGen.getConstantPool());
                                            if (t.getSignature().equals("Ljava/lang/Class;")) {
                                                v = (ConstantClass)ldc.getValue(methodGen.getConstantPool());
                                                initializationOf = ClassName.toSignature(v.getBytes(javaClass.getConstantPool()));
                                                foundDeadClassInitialization = true;
                                                break block74;
                                            }
                                            if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                            continue;
                                        }
                                        catch (Throwable var49_63) {
                                            if (pendingBugReportAboutOverwrittenParameter != null) {
                                                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                            }
                                            throw var49_63;
                                        }
                                    }
                                    break block73;
lbl157:
                                    // 1 sources

                                    if (!(prevIns instanceof DUP2)) break block73;
                                    cur = location.getHandle().getInstruction();
                                    nxt = location.getHandle().getNext().getInstruction();
                                    if (!(cur instanceof LSTORE) || !(nxt instanceof LRETURN)) break block73;
                                    if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                    this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                    continue;
                                }
                                if (!foundDeadClassInitialization) break block75;
                                if (!classContext.getJavaClass().getSuperclassName().equals("org.apache.axis.client.Stub")) break block76;
                                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                                continue;
                            }
                            bugInstance = new BugInstance(this, "DLS_DEAD_STORE_OF_CLASS_LITERAL", 2).addClassAndMethod(methodGen, sourceFileName).add(lvAnnotation).addType(initializationOf);
                            accumulator.accumulateBug(bugInstance, sourceLineAnnotation);
                            if (pendingBugReportAboutOverwrittenParameter == null) continue;
                            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                            continue;
                        }
                        if (prevIns instanceof LDC || prevIns instanceof ConstantPushInstruction) {
                            propertySet.addProperty(DeadLocalStoreProperty.STORE_OF_CONSTANT);
                        } else if (prevIns instanceof ACONST_NULL) {
                            storeOfNull = true;
                            propertySet.addProperty(DeadLocalStoreProperty.STORE_OF_NULL);
                        }
lbl188:
                        // 5 sources

                        if (typeOfValue instanceof BasicType || Type.STRING.equals(typeOfValue)) {
                            propertySet.addProperty(DeadLocalStoreProperty.BASE_VALUE);
                        }
                        if (!(killedBySubsequentStore = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).killedByStore(liveStoreSet, local))) ** GOTO lbl200
                        if (!propertySet.containsProperty(DeadLocalStoreProperty.STORE_OF_NULL) && !propertySet.containsProperty(DeadLocalStoreProperty.STORE_OF_CONSTANT)) break block77;
                        if (pendingBugReportAboutOverwrittenParameter == null) continue;
                        this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                        continue;
                    }
                    propertySet.addProperty(DeadLocalStoreProperty.KILLED_BY_SUBSEQUENT_STORE);
lbl200:
                    // 2 sources

                    prev = location.getBasicBlock().getPredecessorOf(location.getHandle());
                    prevOpCode = -1;
                    if (prev != null) {
                        if (FindDeadLocalStores.defensiveConstantValueOpcodes.get(prev.getInstruction().getOpcode())) {
                            propertySet.addProperty(DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE);
                            prevOpCode = prev.getInstruction().getOpcode();
                        }
                        if (prev.getInstruction() instanceof GETFIELD && (prev2 = prev.getPrev()) != null && prev2.getInstruction() instanceof ALOAD) {
                            propertySet.addProperty(DeadLocalStoreProperty.CACHING_VALUE);
                        }
                        if (prev.getInstruction() instanceof LoadInstruction) {
                            propertySet.addProperty(DeadLocalStoreProperty.COPY_VALUE);
                        }
                        if (prev.getInstruction() instanceof InvokeInstruction) {
                            propertySet.addProperty(DeadLocalStoreProperty.METHOD_RESULT);
                        }
                    }
                    deadObjectStore = false;
                    if (ins instanceof IINC) {
                        if (method.getName().equals("main") && method.isStatic() && method.getSignature().equals("([Ljava/lang/String;)V")) {
                            propertySet.addProperty(DeadLocalStoreProperty.DEAD_INCREMENT_IN_MAIN);
                        }
                        propertySet.addProperty(DeadLocalStoreProperty.DEAD_INCREMENT);
                        if (localIncrementCount[local] == 1) {
                            propertySet.addProperty(DeadLocalStoreProperty.SINGLE_DEAD_INCREMENT);
                        } else {
                            propertySet.removeProperty(DeadLocalStoreProperty.IS_PARAMETER);
                        }
                    } else if (ins instanceof ASTORE && prev != null) {
                        prevIns = prev.getInstruction();
                        if (prevIns instanceof INVOKESPECIAL && ((INVOKESPECIAL)prevIns).getMethodName(methodGen.getConstantPool()).equals("<init>") || prevIns instanceof ANEWARRAY || prevIns instanceof NEWARRAY || prevIns instanceof MULTIANEWARRAY) {
                            deadObjectStore = true;
                        } else if (prevIns instanceof DUP) {
                            propertySet.addProperty(DeadLocalStoreProperty.DUP_THEN_STORE);
                        }
                    }
                    if (deadObjectStore) {
                        propertySet.addProperty(DeadLocalStoreProperty.DEAD_OBJECT_STORE);
                    } else if (!killedBySubsequentStore && localStoreCount[local] == 2 && localLoadCount[local] > 0) {
                        propertySet.addProperty(DeadLocalStoreProperty.TWO_STORES_MULTIPLE_LOADS);
                    } else if (!parameterThatIsDeadAtEntry && localStoreCount[local] == 1 && localLoadCount[local] == 0 && propertySet.containsProperty(DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE)) {
                        propertySet.addProperty(DeadLocalStoreProperty.SINGLE_STORE);
                    } else if (!parameterThatIsDeadAtEntry && !propertySet.containsProperty(DeadLocalStoreProperty.SHADOWS_FIELD) && localLoadCount[local] == 0) {
                        propertySet.addProperty(DeadLocalStoreProperty.NO_LOADS);
                    }
                    if (!(storeOfNull || typeOfValue == null || propertySet.containsProperty(DeadLocalStoreProperty.EXCEPTION_HANDLER) || !(signatureOfValue = typeOfValue.getSignature()).startsWith("Ljava/sql/") && !signatureOfValue.startsWith("Ljavax/sql/") || signatureOfValue.endsWith("Exception"))) {
                        propertySet.addProperty(DeadLocalStoreProperty.STORE_OF_DATABASE_VALUE);
                    }
                    if (parameterThatIsDeadAtEntry) {
                        propertySet.addProperty(DeadLocalStoreProperty.PARAM_DEAD_ON_ENTRY);
                        if (pendingBugReportAboutOverwrittenParameter != null) {
                            pendingBugReportAboutOverwrittenParameter.setPriority(1);
                        }
                    }
                    if (localStoreCount[local] > 3) {
                        propertySet.addProperty(DeadLocalStoreProperty.MANY_STORES);
                    }
                    if ((occurrences = cfg.getLocationsContainingInstructionWithOffset(pc).size()) > 2 || sourceLineAnnotation.getStartLine() > 0 && linesMentionedMultipleTimes.get(sourceLineAnnotation.getStartLine())) {
                        propertySet.addProperty(DeadLocalStoreProperty.CLONED_STORE);
                    }
                    sourceFile = javaClass.getSourceFileName();
                    if (!javaClass.getClassName().endsWith("_jsp")) break block79;
                    propertySet.addProperty(DeadLocalStoreProperty.IN_JSP_PAGE);
                    ** GOTO lbl282
                }
                if (!javaClass.isSynthetic() && (sourceFile == null || sourceFile.endsWith(".java"))) ** GOTO lbl282
                if (!sourceFile.endsWith(".gxp") || !lvName.startsWith("gxp$") && !lvName.startsWith("gxp_")) break block78;
                if (pendingBugReportAboutOverwrittenParameter == null) continue;
                this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
                continue;
            }
            propertySet.addProperty(DeadLocalStoreProperty.NOT_JAVA);
lbl282:
            // 3 sources

            bugPattern = storeOfNull != false ? "DLS_DEAD_LOCAL_STORE_OF_NULL" : (shadowedField != null ? "DLS_DEAD_LOCAL_STORE_SHADOWS_FIELD" : "DLS_DEAD_LOCAL_STORE");
            bugInstance = new BugInstance(this, bugPattern, 2).addClassAndMethod(methodGen, sourceFileName).add(lvAnnotation);
            if (shadowedField != null) {
                bugInstance.addField(FieldAnnotation.fromBCELField(classContext.getJavaClass(), shadowedField)).describe("FIELD_DID_YOU_MEAN");
            }
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                WarningPropertyUtil.addPropertiesForDataMining(propertySet, classContext, method, location);
            }
            propertySet.decorateBugInstance(bugInstance);
            if (FindDeadLocalStores.DEBUG) {
                System.out.println(sourceFileName + " : " + methodGen.getName());
                System.out.println("priority: " + bugInstance.getPriority());
                System.out.println("Reporting " + bugInstance);
                System.out.println(propertySet);
            }
            accumulator.accumulateBug(bugInstance, sourceLineAnnotation);
            if (pendingBugReportAboutOverwrittenParameter == null) continue;
            this.bugReporter.reportBug(pendingBugReportAboutOverwrittenParameter);
        }
        this.suppressWarningsIfOneLiveStoreOnLine(accumulator, liveStoreSourceLineSet);
        accumulator.reportAccumulatedBugs();
    }

    private void suppressWarningsIfOneLiveStoreOnLine(BugAccumulator accumulator, BitSet liveStoreSourceLineSet) {
        if (!SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE) {
            return;
        }
        Iterator<? extends BugInstance> i = accumulator.uniqueBugs().iterator();
        block0: while (i.hasNext()) {
            for (SourceLineAnnotation sourceLineAnnotation : accumulator.locations(i.next())) {
                if (!liveStoreSourceLineSet.get(sourceLineAnnotation.getStartLine())) continue;
                i.remove();
                continue block0;
            }
        }
    }

    private void countLocalStoresLoadsAndIncrements(int[] localStoreCount, int[] localLoadCount, int[] localIncrementCount, CFG cfg) {
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            if (location.getBasicBlock().isExceptionHandler()) continue;
            boolean isStore = this.isStore(location);
            boolean isLoad = this.isLoad(location);
            if (!isStore && !isLoad) continue;
            IndexedInstruction ins = (IndexedInstruction)((Object)location.getHandle().getInstruction());
            int local = ins.getIndex();
            if (ins instanceof IINC) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                int n2 = local;
                localLoadCount[n2] = localLoadCount[n2] + 1;
                int n3 = local;
                localIncrementCount[n3] = localIncrementCount[n3] + 1;
                continue;
            }
            if (isStore) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                continue;
            }
            int n = local;
            localLoadCount[n] = localLoadCount[n] + 1;
        }
    }

    private void checkLocalVariableName(LocalVariableTable lvt, int local, int pc, WarningPropertySet<DeadLocalStoreProperty> propertySet) {
        LocalVariable lv;
        if (lvt != null && (lv = lvt.getLocalVariable(local, pc)) != null) {
            String localName = lv.getName();
            propertySet.setProperty(DeadLocalStoreProperty.LOCAL_NAME, localName);
        }
    }

    private boolean isStore(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof StoreInstruction || ins instanceof IINC;
    }

    private boolean isLoad(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LoadInstruction || ins instanceof IINC;
    }

    @Override
    public void report() {
    }

    static {
        EXCLUDED_LOCALS.add("gxp_locale");
        String exclLocalsProperty = SystemProperties.getProperty(FINDBUGS_EXCLUDED_LOCALS_PROP_NAME);
        if (exclLocalsProperty != null) {
            for (String s : exclLocalsProperty.split(",")) {
                String s2 = s.trim();
                if (s2.length() <= 0) continue;
                EXCLUDED_LOCALS.add(s2);
            }
        }
        SUPPRESS_IF_AT_LEAST_ONE_LIVE_STORE_ON_LINE = SystemProperties.getBoolean("findbugs.dls.suppressIfOneLiveStore");
        defensiveConstantValueOpcodes = new BitSet();
        defensiveConstantValueOpcodes.set(14);
        defensiveConstantValueOpcodes.set(15);
        defensiveConstantValueOpcodes.set(11);
        defensiveConstantValueOpcodes.set(12);
        defensiveConstantValueOpcodes.set(1);
        defensiveConstantValueOpcodes.set(2);
        defensiveConstantValueOpcodes.set(3);
        defensiveConstantValueOpcodes.set(4);
        defensiveConstantValueOpcodes.set(5);
        defensiveConstantValueOpcodes.set(6);
        defensiveConstantValueOpcodes.set(7);
        defensiveConstantValueOpcodes.set(8);
        defensiveConstantValueOpcodes.set(9);
        defensiveConstantValueOpcodes.set(10);
        defensiveConstantValueOpcodes.set(18);
        defensiveConstantValueOpcodes.set(19);
        defensiveConstantValueOpcodes.set(20);
    }
}

