//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IStructuringTemporalRelationship;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
abstract class StructuringTemporalRelationship extends Task
    implements IStructuringTemporalRelationship
{

    /**  */
    private static final long serialVersionUID = 1L;
    
    /**
     * 
     */
    private List<ITask> children = new LinkedList<ITask>();

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param description
     */
    StructuringTemporalRelationship(String relationshipType) {
        if ((relationshipType == null) || ("".equals(relationshipType))) {
            throw new IllegalArgumentException
                ("the relationship type must be something meaningful");
        }
        
        super.setDescription(relationshipType);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.IStructuringTemporalRelationship#getChildren()
     */
    @Override
    public List<ITask> getChildren() {
        return children;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.Task#clone()
     */
    @Override
    public synchronized StructuringTemporalRelationship clone() {
        StructuringTemporalRelationship clone = null;
        clone = (StructuringTemporalRelationship) super.clone();
            
        clone.children = new LinkedList<ITask>();
        
        for (ITask child : this.children) {
            clone.children.add(child.clone());
        }

        return clone;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param i
     * @param newChild
     */
    public void addChild(ITask newChild) {
        children.add(newChild);
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param i
     * @param newChild
     */
    public void addChild(int index, ITask newChild) {
        children.add(index, newChild);
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param index
     */
    void removeChild(int index) {
        children.remove(index);
    }
}
