//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.tasktree;

import java.util.List;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class FilterResult {

    @SuppressWarnings("rawtypes")
    private final Predicate filterPredicate;

    private List<ITaskTreeNode> filteredNodes = Lists.newArrayList();

    private List<ITaskTreeNode> nodesNotMatchedFilter = Lists.newArrayList();

    @SuppressWarnings("rawtypes")
    public FilterResult(Predicate filterPredicate) {
        this.filterPredicate = filterPredicate;
    }

    @SuppressWarnings("unchecked")
    public void addNode(ITaskTreeNode node) {
        if (filterPredicate.apply(node)) {
            filteredNodes.add(node);
        }
        else {
            nodesNotMatchedFilter.add(node);
        }
    }

    public List<ITaskTreeNode> nodesMatchedFilter() {
        return this.filteredNodes;
    }

    public int nrOfNodesMatchedFilter() {
        return this.filteredNodes.size();
    }

    public List<ITaskTreeNode> nodesNotMatchedFilter() {
        return this.nodesNotMatchedFilter;
    }

    public int nrOfNodesNotMatchedFilter() {
        return this.nodesNotMatchedFilter.size();
    }

}
