/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class FindFieldSelfAssignment
extends OpcodeStackDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    int state;
    int register;
    Set<String> initializedFields = new HashSet<String>();

    public FindFieldSelfAssignment(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.state = 0;
        super.visit(obj);
        this.initializedFields.clear();
    }

    public void sawOpcode(int seen) {
        if (seen == 181) {
            OpcodeStack.Item top = this.stack.getStackItem(0);
            OpcodeStack.Item next = this.stack.getStackItem(1);
            XField f = top.getXField();
            int registerNumber = next.getRegisterNumber();
            if (f != null && f.equals(this.getXFieldOperand()) && registerNumber >= 0 && registerNumber == top.getFieldLoadedFromRegister()) {
                int priority = 2;
                LocalVariableAnnotation possibleMatch = LocalVariableAnnotation.findMatchingIgnoredParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                if (possibleMatch != null) {
                    --priority;
                } else {
                    possibleMatch = LocalVariableAnnotation.findUniqueBestMatchingParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                }
                if (possibleMatch == null) {
                    String signature = this.stack.getLVValue(registerNumber).getSignature();
                    for (int i = 0; i < this.stack.getNumLocalValues(); ++i) {
                        OpcodeStack.Item lvValue;
                        if (i == this.register || (lvValue = this.stack.getLVValue(i)) == null || !lvValue.getSignature().equals(signature)) continue;
                        --priority;
                        break;
                    }
                }
                this.bugReporter.reportBug(new BugInstance(this, "SA_FIELD_SELF_ASSIGNMENT", priority).addClassAndMethod(this).addReferencedField(this).addOptionalAnnotation(possibleMatch).addSourceLine(this));
            }
        }
        switch (this.state) {
            case 0: {
                if (seen != 89) break;
                this.state = 6;
                break;
            }
            case 6: {
                if (this.isRegisterStore()) {
                    this.state = 7;
                    this.register = this.getRegisterOperand();
                    break;
                }
                this.state = 0;
                break;
            }
            case 7: {
                if (this.isRegisterStore() && this.register == this.getRegisterOperand()) {
                    this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_DOUBLE_ASSIGNMENT", 2).addClassAndMethod(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.register, this.getPC(), this.getPC() - 1)).addSourceLine(this));
                }
                this.state = 0;
            }
        }
    }
}

