/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldOrMethodName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldOrMethodDescriptor
implements FieldOrMethodName {
    @SlashedClassName
    private final String slashedClassName;
    private final String name;
    private final String signature;
    private final boolean isStatic;
    private int cachedHashCode;
    private final int nameSigHashCode;

    public FieldOrMethodDescriptor(@SlashedClassName String slashedClassName, String name, String signature, boolean isStatic) {
        assert (slashedClassName.indexOf(46) == -1) : "class name not in VM format: " + slashedClassName;
        this.slashedClassName = DescriptorFactory.canonicalizeString(slashedClassName);
        this.name = DescriptorFactory.canonicalizeString(name);
        this.signature = DescriptorFactory.canonicalizeString(signature);
        this.isStatic = isStatic;
        this.nameSigHashCode = FieldOrMethodDescriptor.getNameSigHashCode(this.name, this.signature);
    }

    public static int getNameSigHashCode(String name, String signature) {
        return name.hashCode() * 3119 + signature.hashCode() * 131;
    }

    public int getNameSigHashCode() {
        return this.nameSigHashCode;
    }

    @SlashedClassName
    public String getSlashedClassName() {
        return this.slashedClassName;
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return DescriptorFactory.createClassDescriptor(this.slashedClassName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    protected int compareTo(FieldOrMethodName o) {
        int cmp = this.getClassDescriptor().compareTo(o.getClassDescriptor());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareTo(o.getName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.signature.compareTo(o.getSignature());
        if (cmp != 0) {
            return cmp;
        }
        return (this.isStatic ? 1 : 0) - (o.isStatic() ? 1 : 0);
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FieldOrMethodDescriptor)) {
            return false;
        }
        FieldOrMethodDescriptor other = (FieldOrMethodDescriptor)obj;
        return this.isStatic == other.isStatic && this.slashedClassName.equals(other.slashedClassName) && this.name.equals(other.name) && this.signature.equals(other.signature);
    }

    public final int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.slashedClassName.hashCode() * 7919 + this.nameSigHashCode + (this.isStatic ? 1 : 0);
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return (this.isStatic ? "static " : "") + this.getClassDescriptor().getDottedClassName() + "." + this.name + this.signature;
    }

    public static <T extends FieldOrMethodDescriptor> int compareTo(T thas, T that) {
        int result = thas.slashedClassName.compareTo(that.slashedClassName);
        if (result != 0) {
            return result;
        }
        result = thas.name.compareTo(that.name);
        if (result != 0) {
            return result;
        }
        result = thas.signature.compareTo(that.signature);
        if (result != 0) {
            return result;
        }
        result = (thas.isStatic ? 1 : 0) - (that.isStatic ? 1 : 0);
        return result;
    }
}

