/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private int index;

    public SimpleElementValue(int type, int index, ConstantPool cpool) {
        super(type, cpool);
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.getIndex(), (byte)1);
        return c.getBytes();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return c.getBytes();
    }

    public byte getValueByte() {
        if (this.type != 66) {
            throw new RuntimeException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return (byte)c.getBytes();
    }

    public char getValueChar() {
        if (this.type != 67) {
            throw new RuntimeException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
        return (char)c.getBytes();
    }

    public long getValueLong() {
        if (this.type != 74) {
            throw new RuntimeException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong j = (ConstantLong)this.cpool.getConstant(this.getIndex());
        return j.getBytes();
    }

    public float getValueFloat() {
        if (this.type != 70) {
            throw new RuntimeException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat f = (ConstantFloat)this.cpool.getConstant(this.getIndex());
        return f.getBytes();
    }

    public double getValueDouble() {
        if (this.type != 68) {
            throw new RuntimeException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble d = (ConstantDouble)this.cpool.getConstant(this.getIndex());
        return d.getBytes();
    }

    public boolean getValueBoolean() {
        if (this.type != 90) {
            throw new RuntimeException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.getIndex());
        return bo.getBytes() != 0;
    }

    public short getValueShort() {
        if (this.type != 83) {
            throw new RuntimeException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger s = (ConstantInteger)this.cpool.getConstant(this.getIndex());
        return (short)s.getBytes();
    }

    public String toString() {
        return this.stringifyValue();
    }

    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(c.getBytes());
            }
            case 74: {
                ConstantLong j = (ConstantLong)this.cpool.getConstant(this.getIndex(), (byte)5);
                return Long.toString(j.getBytes());
            }
            case 68: {
                ConstantDouble d = (ConstantDouble)this.cpool.getConstant(this.getIndex(), (byte)6);
                return Double.toString(d.getBytes());
            }
            case 70: {
                ConstantFloat f = (ConstantFloat)this.cpool.getConstant(this.getIndex(), (byte)4);
                return Float.toString(f.getBytes());
            }
            case 83: {
                ConstantInteger s = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(s.getBytes());
            }
            case 66: {
                ConstantInteger b = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return Integer.toString(b.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                return String.valueOf((char)ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.getIndex(), (byte)3);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                if (bo.getBytes() != 0) {
                    return "true";
                }
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.getIndex(), (byte)1);
                return cu8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValue class does not know how to stringify type " + this.type);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.getIndex());
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValue doesnt know how to write out type " + this.type);
            }
        }
    }
}

