//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public interface ITaskBuilder {

    /**
     * @param taskInstance
     * @param child
     */
    void addChild(ITaskInstance taskInstance, ITaskInstance child) throws IllegalArgumentException;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param session
     * @param taskInstance
     */
    void addExecutedTask(IUserSession session, ITaskInstance taskInstance);

    /**
     * 
     * @param parent
     * @param i
     */
    void addTaskInstance(ITaskInstanceList taskInstanceList, ITaskInstance taskInstance);

    /**
     * 
     * @param parent
     * @param i
     */
    void addTaskInstance(ITaskInstanceList taskInstanceList, int index, ITaskInstance taskInstance);

    /**
     * 
     * @param parent
     * @param i
     */
    void setTaskInstance(ITaskInstanceList taskInstanceList, int index, ITaskInstance taskInstance);

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param instance2
     * @param task
     */
    void setTask(ITaskInstance taskInstance, ITask task);

    /**
     *
     */
    void addChild(ISequence parent, ITask child);

    /**
     *
     */
    void addChild(ISequence parent, int index, ITask child);

    /**
     * 
     * @param parent
     * @param i
     */
    void setChild(ISequence parent, int index, ITask child);

    /**
     * @param sequence
     * @param task
     */
    void addChild(ISelection parent, ITask child);

    /**
     * 
     * @param iteration
     * @param newChild
     */
    void setMarkedTask(IIteration iteration, ITask newChild);

    /**
     * 
     * @param optional
     * @param newChild
     */
    void setMarkedTask(IOptional optional, ITask newChild);

    /**
     * 
     * @param parent
     * @param i
     */
    void removeChild(ISequence parent, int index);

    /**
     *
     * @param parent
     * @param i
     */
    void removeChild(ISelection parent, ITask child);

    /**
     * 
     * @param parent
     * @param i
     */
    void removeTaskInstance(ITaskInstanceList taskInstanceList, int index);

    /**
     *
     * @param parent
     * @param i
     */
    void replaceChild(ISelection parent, ITask oldChild, ITask newChild);

    /**
     * 
     * @param parent
     * @param i
     */
    void setDescription(ITask task, String description);

}
