//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.logging.Level;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.rules.UsabilityResult;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRule;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRuleset;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityEvaluator {
    
    private ITaskTree taskTree;

    private UsabilityEvaluator(ITaskTree taskTree) {
        this.taskTree = taskTree;
    }
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param taskTree
     * @return
     */
    public static UsabilityEvaluator evaluate(ITaskTree taskTree) {
        return new UsabilityEvaluator(taskTree);
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param object
     * @return
     */
    public UsabilityResult using(UsabilityRuleset ruleset) {
        Console.traceln(Level.INFO, "evaluating usability of task tree " + this.taskTree);
        UsabilityResult result = new UsabilityResult();
        for(UsabilityRule rule : ruleset.evaluationRules()) {
            Optional<UsabilityDefect> defect = rule.check();
            if(defect.isPresent()) {
                result.addDefect(defect.get());
            }
        }
        return result;
    }

}
