//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.tasktrees.query.TaskTreeQueryProcessor;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.util.console.Console;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityEvaluationManager {
    
    /** */
    private List<UsabilityEvaluationRule> rules = new ArrayList<UsabilityEvaluationRule>();

    /**
     * TODO: comment
     * 
     */
    public UsabilityEvaluationManager() {
        super();
        init();
    }

    /**
     * TODO: comment
     * 
     */
    private void init() {
        rules.add(new TextInputStatisticsRule());
    }

    /**
     * TODO: comment
     * 
     * @param taskTree
     */
    public UsabilityEvaluationResult evaluateUsability(ITaskModel taskTree) {
        Console.traceln(Level.INFO, "evaluating usability of task tree " + taskTree);

        List<UsabilityEvaluationResult> results = new ArrayList<UsabilityEvaluationResult>();
        TaskTreeQueryProcessor queryProcessor = new TaskTreeQueryProcessor(taskTree);

        for (UsabilityEvaluationRule rule : rules) {
            Console.traceln(Level.INFO, "applying rule " + rule.getClass().getSimpleName());
            UsabilityEvaluationResult result = rule.evaluate(queryProcessor);
            results.add(result);
            Console.traceln(Level.INFO, "the rule found " + result.getAllDefects().size() +
                            " usability defects, of which " + result.getSevereDefects().size() +
                            " are severe.");
        }

        UsabilityEvaluationResult result = mergeResults(results);
        Console.println("the evaluation result contains " + result.getAllDefects().size() +
                        " defects, of which " + result.getSevereDefects().size() + " are severe.");
        return result;
    }

    /**
     * TODO: comment
     * 
     * @param results
     * @return
     */
    private UsabilityEvaluationResult mergeResults(List<UsabilityEvaluationResult> results) {
        UsabilityEvaluationResult result = new UsabilityEvaluationResult();

        for (UsabilityEvaluationResult ruleResult : results) {
            for (UsabilityDefect defect : ruleResult.getAllDefects()) {
                result.addDefect(defect);
            }
        }

        return result;
    }

}
