//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.UsagePatternVisitor;
import de.ugoe.cs.autoquest.usability.util.PatternsVisitorUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithPatternVisitor extends UsagePatternVisitor {

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param startsWithPattern
     */
    public StartsWithPatternVisitor(UsagePattern startsWithPattern) {
        this.containedPattern = startsWithPattern;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc.IIteration)
     */
    public void visit(IIteration iteration) {
        ITaskTree taskTree = PatternsVisitorUtil.createTaskTreeFromNode(iteration);
        this.present = containedPattern.containedIn(taskTree);  
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor#visit(de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence)
     */
    public void visit(ISequence sequence) {
        ITaskTreeNode firstNode = PatternsVisitorUtil.firstNodeOf(sequence.getChildren());
        ITaskTree taskTree;
        if(isEvent(firstNode)) {
            taskTree = PatternsVisitorUtil.createTaskTreeFromNode(sequence);
        } else {
            taskTree = PatternsVisitorUtil.createTaskTreeFromNode(firstNode);
        }
        this.present = containedPattern.containedIn(taskTree);      
    }

    private boolean isEvent(ITaskTreeNode firstNode) {
        return firstNode.getChildren().isEmpty();
    }

}
