//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.util;

import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class NullNode implements ITaskTreeNode {

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode#getName()
     */
    public String getName() {
        return StringUtils.EMPTY;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode#getDescription()
     */
    public String getDescription() {
        return StringUtils.EMPTY;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode#getChildren()
     */
    public List<ITaskTreeNode> getChildren() {
        return Collections.emptyList();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode#equals(de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode)
     */
    public boolean equals(ITaskTreeNode taskTreeNode) {
        return false;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     */
    @Override
    public NullNode clone() {
        return (NullNode) this;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode#accept(de.ugoe.cs.autoquest.tasktrees.treeifc.NodeVisitor)
     */
    public void accept(NodeVisitor visitor) {
        
    }
    
}

